
setwd("~/research/multiple_loci_mapping/bayesian/code")
        
md = read.table("genotype_data.txt")
mi = read.table("genotype_info.txt", header=TRUE)
mi[["ID"]] = 1:nrow(mi)
names(mi)[2:3]  = c("chrom", "start")
mm = data.matrix(t(md[,1:60]))

sex = runif(360)
sex[sex >  0.5] = 1
sex[sex <= 0.5] = 0

me = matrix(0, nrow=10, ncol=360)
x  = mm[1,]
y  = 0.4*x + 0.4*x*sex + 0.8*rnorm(360)
l  = lm(y~x + x:sex)
summary(l)

me[1,] = y

for(i in 2:10){
  me[i,] = rnorm(360)
}

simuD = list(expression=me, genotype=mm, gtpinfo=mi[1:60,], sex=sex)
package.skeleton("tmp", "simuD")
