\name{related.ind}
\alias{related.ind}
\title{ identify related individuals }
\description{
  identified related individuals based on a distance matrix 
  that include the distances between any pair of individuals.
}
\usage{
related.ind(distm, ind.syms, dist.cut.type = "boxplot",
 dist.cutoff = NULL)
}
\arguments{
  \item{distm}{ a distance matrix, generated from function dist.matrix. 
  Users can suppley matrix by user-defined distances, but need to make 
  sure the matrix is symmetric and with class ``distm'' }
  \item{ind.syms}{ individual symbols }
  \item{dist.cut.type}{ type of distance cutoff, now the allowed values
  are ``boxplot'', ``percent'', and ``value''. }
  \item{dist.cutoff}{ distance cutoff value }
}
\details{
  If dist.cut.type = ``boxplot'', we choose those individual pairs whose 
  distnace are defined as outliers by boxplot. 
  If dist.cut.type = ``percent'', distcuoff should be percentage 
  in the range [0,1]. We choose those individual pairs whose 
  distnaces are smaller than the corresponding percentile. 
  If dist.cut.type = ``value'', we choose those individual pairs whose 
  distnaces are smaller than dist.cutoff. 
}
\value{
a dataframe of individaul pairs close to each other. 
}
\examples{
  data(mData.y112)
  mm = data.matrix(mData.y112)
  di = dist.matrix(mm, "r2")
  rd = related.ind(di, paste("y", 1:112, sep=""), "value", 0.85)
}
\author{ Wei Sun wsun@bios.unc.edu }
\seealso{ \code{\link{dist.matrix}} }
\keyword{ methods }
