\name{module.score}
\alias{module.score}

\title{ calculate a score for an eQTL module }
\description{
  calculate the score of an eQTL module
}
\usage{
module.score(eD, mc, q = 0.01, sex = NULL, use.dom = FALSE)
}
\arguments{
  \item{eD}{ a matrix, the expression data of the genes within a
  eQTL module, each row corresponds to one gene}
  \item{mc}{ a vector, the genotype of one marker }
  \item{q}{ p-value cutoff. see details }
  \item{sex}{ an optional covariate in the linear model }
  \item{use.dom}{ whether to include dominant genetic effect }
}
\details{
  Given an eQTL module, a representative genotype profile (mc) and
  the expression of all the genes linked to it (eD).
  We evaluate the significance of an eQTL hotspot as follows.
  Fist, find the gene that is most significantly associated with
  mc; record it as e1 and the corresponding p-value as $p_1$.
  Next, from all the remaining genes, find the gene y with
  the smallest p-value for $\gamma$ in model
  $y = \beta_0 + \beta_1 e1 + \gamma mc + \epsilon$;
  record it as e2 and the corresponding p-value as $p_2$.
  Then include both e1 and e2 into the model to identify the third
  gene. Repeat this procedure until all genes are considered,
  then we can calculate a score for the hotspot as
  $\sum_{p_i \leq q} \log(p_i)$. Here q is the p-value cutoff,
  so that only p-values smaller than p.cut contribute to the score.
}
\value{
  \item{geneID }{The rows in matrix eD that are selected to calculate
    the module score}
  \item{pval }{A vector of the p-values $(p_1, p_2, ..., p_k)$,
    such that $p_k \leq q$ }
  \item{pval }{ the module score $\sum_{p_i \leq q} \log(p_i)$.}
}

\author{ Wei Sun wsun@bios.unc.edu }
\seealso{ \code{\link{eQTL.module}} }
\examples{
data(eData.y112)
data(mData.y112)
data(mInfo.y112)
data(eqtl.y112)
eqtl = eqtl.y112
eqtl = eqtl[eqtl$pValue <= 1e-6,]
module = eQTL.module(eData.y112, mData.y112, mInfo.y112, eqtl,
  p.binom = 0.05, plrt.cut = 0.1, prop.cut = 0.2, haploid = TRUE)

mIDs = module$chr15$mod1$mID
mc   = mData.y112[mIDs[1],]
eIDs = module$chr15$mod1$eID
eD   = eData.y112[eIDs,]

module.score(eD, mc)
}
\keyword{ methods }

