\name{lmEQTL.slr}
\alias{lmEQTL.slr}
\title{ simple linear regression for eQTL }
\description{
  Identify significant eQTL by simple linear regression, i.e.,
  y = a + bx.
}

\usage{
lmEQTL.slr(me, mm, output.tag, p.cut, cis.only=FALSE, cis.distance=1e6, 
  eChr=NULL, ePos=NULL, mChr=NULL, mPos=NULL, tol=1e-7,
  nna.percent=0.75)
}
\arguments{
  \item{me}{ matrix of gene expression }
  \item{mm}{ matrix of marker genotype, could be any numerical matrix }
  \item{output.tag}{ output file name tag }
  \item{p.cut}{ p-value cut-off for p-value of the slope. }
  \item{cis.only}{ whether examine cis-linkage only. }
  \item{cis.distance}{ if the distance between a gene and a marker
   is smaller than cis.distance, we call it as cis-linkage. }
  \item{eChr}{ chromosomes of gene expression traits, must be
   a vector of integers, which means sex chromosomes (X, Y) need
   to be coded as numbers }
  \item{ePos}{ positions of gene expression traits, must be
   a vector of integers}
  \item{mChr}{ chromosomes of markers, must be a vector of integers,
   which means sex chromosomes (X, Y) need to be coded as numbers }
  \item{mPos}{ positions of markers, must be a vector of integers}
  \item{tol}{ components of model matrix are discarded if the ratio
   of singular values $s_i/s_0$ falls below tol. }
  \item{nna.percent}{ minimum percentage of non-missing values. }
}
\value{
The function return 1 if no error occurs.
 The results are written into
 two output files: one file for mapping result, including gene ID,
 marker ID, regression coefficient, and p-value;
 the other file is a frequency table of the p-values.}
\examples{
  data(simuD)
  me  = simuD$expression
  mm  = simuD$genotype
  sex = simuD$sex
  
  lmEQTL.slr(me, mm, output.tag="test_lmEQTL", p.cut=0.01)
}
\author{ Wei Sun wsun@bios.unc.edu }
\keyword{ methods }
