\name{eQTL.reduce}
\alias{eQTL.reduce}
\title{ eliminate the redundant result in eQTL mapping result }
\description{
  For each gene, if it has multiple significant linkages
  in one chromosome, only the most significant one is kept
  and others are removed.
}
\usage{
eQTL.reduce(path, input, output, markerInfo)
}
\arguments{
  \item{path}{ the file path }
  \item{input}{ the input file name. The input file should
   be output file of lmEQTL }
  \item{output}{ the output file name }
  \item{markerInfo}{ a data.frame including information of marker.
   It must have at least three components: ID, chrom and start }
}
\value{
    result are written into the output file
}
\examples{
  data(simuD)
  me  = simuD$expression
  mm  = simuD$genotype
  im  = simuD$gtpinfo
  sex = simuD$sex
  lmEQTL(me, mm, sex, output.tag="test_lmEQTL", p.cut=0.01, type=2)
  eQTL.reduce("./", "test_lmEQTL_eqtl.txt", "test_lmEQTL_byChr_eqtl.txt", im)
}
\author{ Wei Sun wsun@bios.unc.edu }
\seealso{ \code{\link{lmEQTL}} }
\keyword{ methods }
