\name{eQTL.module}
\alias{eQTL.module}
\title{ Identify eQTL module based on eqtl mapping result }
\description{
  Identify eQTL module, i.e., the eQTL hotspot and the genes linked
  there.
}
\usage{
eQTL.module(eData, mData, mInfo, eqtls, neqtl.cut = NULL, p.binom = 0.05, plrt.cut = 0.05, prop.cut = 0.05, haploid = TRUE)
}
\arguments{
  \item{eData}{ data matrix of gene expression data, each row
    corresponds to a gene and each column corresponds to an individual }
  \item{mData}{ data matrix of marker genotype, each row
    corresponds to a marker and each column corresponds to an individual }
  \item{mInfo}{ a data.frame of the marker information, which
    include at least four variables: ID, markerSym, chr (chromosome),
     and start}
  \item{eqtls}{ a data frame of eqtl mapping result.
    This data.frame should include at least three variables:
    markerID, geneID, and pValue}
  \item{neqtl.cut}{ if more than neqtl.cut gene expression traits
   are linked to one marker, this marker is one module or part of
   one module }
  \item{p.binom}{ if neqtl.cut is not specified, use binomial
    distribution to calculate neqtl.cut, \code{p.binom} is the
    p-value cut-off of binomial distribution }
  \item{plrt.cut}{ p-value cut-off of likelihood ratio test
    deciding whether the association from one gene expression trait
    and one marker describes the gene expression data better
    than the assocition to anohter marker.}
  \item{prop.cut}{ If there are multiple genes
   are associated with one marker, it could happen by chance that
   one likelihood ratio test p-value is smaller than cut-off value.
   prop.cut provide the cut-off of proportion of such
   significant p-values }
  \item{haploid}{ whether the organism is haploid.
   This function only handle SNP markers. So if the organism is
   haploid, the marker data mData is a matrix with only two values:
   -1 and 1. If the organism is diploid, the marker data mData
   is a matrix with three values -1, 0, and 1. Here -1 and 1 correspond
   to homozygous genotype and 0 corrspond to heterzygous genotype. }
}
\details{
 Different from commonly used moving window approach, we identify
 eQTL hotspots by likelihood ratio tests and allow variable sizes of
 the hotspots.
}
\value{
  A list of two components:
  \item{neqtlCut }{ the cut-off value of number of genes linked
    to one marker, it equals to either the parameter neatlCut or
    it is calculated based p.binom}
  \item{chri }{a list including all the modules found in chromosome i}
}
\author{ Wei Sun sunwei@stat.ucla.edu }
\seealso{   \code{\link{plotModule}}}
\examples{
data(eData.y112)
data(mData.y112)
data(mInfo.y112)
data(eqtl.y112)
module = eQTL.module(eData.y112, mData.y112, mInfo.y112, eqtl.y112,
p.binom = 0.05, plrt.cut = 0.1, prop.cut = 0.2, haploid = TRUE)
}
\keyword{ methods }
