\name{eQTL.FDR}
\alias{eQTL.FDR}
\title{ Calculate FDR }
\description{
  Calculate FDR by merging the permutations of diffrent genes.
}
\usage{
eQTL.FDR(path, input.tag, n.permute, pcuts, 
 maf=NULL, maf.cut=NULL, nobs=NULL, nobs.cut=NULL)
}
\note{
  NOTICE, it is efficient to merge premutation results across
  genes so that only a small number of permutations are needed
  for each gene. However, it is more accurate to carry out a
  large number of permutations for each gene and estimate
  permutation p-value gene by gene. See lmEQTL.slr.permute.
}
\arguments{
  \item{path}{ the file path, for example "data/", "D:/eQTL/" }
  \item{input.tag}{ the input file name tag, for permutation result }
  \item{n.permute}{ number of permutations }
  \item{pcuts}{ p-value cutoffs where FDR are evaluated }
  \item{maf}{ minor allele frequency of each marker,
    must be ordered the same as the marker data }
  \item{maf.cut}{ eQTL result of any marker whose maf smaller than
    maf.cut will be dropped}
  \item{nobs}{ number of non-missing observations of each marker }
  \item{nobs.cut}{ eQTL result of any marker whose nobs smaler than
    nobs.cut will be dropped }
}
\value{
  A data.frame
  \item{pcuts }{p-value cutoffs where FDR are evaluated }
  \item{D.link }{number of discovered linkages}
  \item{FD.link }{expected number of false discovery of linkages}
  \item{FDR.link }{FDR of linkages}
  \item{D.gene }{number of discovered genes}
  \item{FD.gene }{expected number of false discovery of genes}
  \item{FDR.gene }{FDR of genes}
}
\examples{
  data(simuD)
  me  = simuD$expression
  mm  = simuD$genotype
  sex = simuD$sex
  lmEQTL(me, mm, sex, "test_lmEQTL", p.cut=0.01, type=2)
  lmEQTL.permute(me, mm, sex, "test_lmEQTL", 5, p.cut=0.01, type=2)
  fdr = eQTL.FDR("./", "test_lmEQTL", 5, pcuts=c(0.01, 0.001, 0.0001))
}
\author{ Wei Sun wsun@bios.unc.edu }
\seealso{ \code{\link{lmEQTL}}, \code{\link{lmEQTL.slr}},
\code{\link{lmEQTL.slr.permute}} }
\keyword{ methods }
