\name{causal.lr}
\alias{causal.lr}
\title{ causal analysis using likelihood ratio test }
\description{
  Identify possible causal relations among three variables by
  comparing likelihood of three different models: causal model,
  reactive model and conditional independence model.
}
\usage{
causal.lr(y0, y1, y2)
}
\arguments{
  \item{y0}{ a numeric vector that can only be cause. For example, \code{y0} is a genetic marker or one cis-linked gene's expression profile}
  \item{y1}{ a numeric vector that is one candidate of linker between y0 and y2}
  \item{y2}{ a numeric vector }
}
\details{
The three models considered are:
causal model (y0 -> y1 -> y2),
reactive model (y0 -> y2 -> y1),
and conditional independence (y1 <- y0 -> y2).
The likelihoods of these three models are calculated.
Then the two most likely models are compared by likelihood ratio test
(for non-nested models) and the p-value as well as the label of the
most likely model is returned.
}
\value{
  a list of four components:
  \item{logL}{log likelihood of causal, reactive, and
    conditional independence model}
  \item{pval}{likelihood ratio test p-value of comparing the
    two most likely models}
  \item{label}{label of the most likely model:
   one of "causal", "reactive", "independent"}
}
\references{ 
Schadt EE, Lamb J, Yang X, Zhu J, Edwards S, Guhathakurta D, Sieberts SK, 
Monks S, Reitman M, Zhang C, Lum PY, Leonardson A, Thieringer R, Metzger JM, 
Yang L, Castle J, Zhu H, Kash SF, Drake TA, Sachs A, Lusis AJ. 
An integrative genomics approach to infer causal associations between gene 
expression and disease. Nat Genet. 2005 Jul;37(7):710-7.

Likelihood ratio test for model selection and non-nested hypotheses. 
Quang H. Vuong. Econometrica, 1989, Vol.57, No.2., pp. 307-333.
}
\author{ Wei Sun wsun@bios.und.edu }
\examples{
    y0 = rnorm(100)
    y1 = y0 + rnorm(100,0,1)
    y2 = y1 + rnorm(100,0,1)
    causal.lr(y0, y1, y2)
}
\keyword{ methods }
