`related.ind` <-
function(distm, ind.syms, dist.cut.type="boxplot", dist.cutoff = NULL)
{
  if(class(distm)!="distm"){
    stop("distm should be output of funciton dist.matrix\n")
  }
    
  if(ncol(distm) != length(ind.syms)){
    stop("dimension of mm ind.syms do not match\n")
  }
  
  if(!dist.cut.type %in% c("boxplot", "percent", "value")){
    stop("invalid dist.cut.type\n")
  }

  distv = as.numeric(distm[upper.tri(distm)])
  if(dist.cut.type=="boxplot"){
    qs = quantile(distv, probs=c(0.25,0.5,0.75))
    dist.cutoff   = qs[1] - 1.5*(qs[3] - qs[1])
    dist.cut.type = "value"
  }
  
  if(dist.cut.type=="percent"){
    if(dist.cutoff > 1 || dist.cutoff < 0){
      stop("invalid dist.cutoff\n")
    }
    dist.cutoff   = quantile(distv, probs=dist.cutoff)
    dist.cut.type = "value"
  }

  distm[lower.tri(distm, diag=TRUE)] = NA
  n = ncol(distm)

  w1 = which(apply(distm[-n,], 1, min, na.rm=TRUE) <= dist.cutoff)
  pair = character(0)
  for(w in w1){
    w2 = which(distm[w,] <= dist.cutoff)
    kp = cbind(w, w2, ind.syms[w], ind.syms[w2], distm[w,w2])
    pair = rbind(pair, kp) 
  }
  if(length(pair) > 0){
    row.names(pair) = NULL
    pair = as.data.frame(pair, stringsAsFactors=FALSE)
    names(pair) = c("ind1.ID", "ind2.ID", "ind1", "ind2", "distance")
    pair$ind1.ID = as.numeric(pair$ind1.ID)
    pair$ind2.ID = as.numeric(pair$ind2.ID)    
    pair$distance = as.numeric(pair$distance)
    pair = pair[order(pair$distance),]
  }
  pair 
}
