"lmEQTL" <-
function(me, mm, sex, output.tag, p.cut, type, add.only=FALSE, 
  detail=FALSE, lrt.p.cut=0.01, tol=1e-7, nna.percent=0.75){

  if(type!=1 && type !=2){
    stop("type must be 1 or 2\n")
  }
  
  if(is.vector(me)){
    ncol.me = length(me)
    nrow.me = 1
  }else{
    ncol.me = ncol(me)
    nrow.me = nrow(me)
  }

  if(is.vector(mm)){
    ncol.mm = length(mm)
    nrow.mm = 1
  }else{
    ncol.mm = ncol(mm)
    nrow.mm = nrow(mm)
  }

  if(ncol.mm != ncol.me){
    stop("mm and me have different number of columns!");
  }

  if(any(is.na(sex))){
    stop("No missing value is not allowed for parameter sex\n");
  }
  
  if(any(sex != 0 & sex != 1)){
    stop("sex variable should only have values 0 or 1\n");
  }
  
  if(ncol.mm != length(sex)){
    stop("number of columns of me(mm) is different from length of sex!");
  }

  dims = numeric(3);
  dims[1] = nrow.me;
  dims[2] = nrow.mm;
  dims[3] = ncol.me;
  succeed = 0;
  
  output = character(2);
  output[1] = sprintf("%s_eqtl.txt", output.tag)
  output[2] = sprintf("%s_freq.txt", output.tag)
  
  me.na = is.na(me);
  mm.na = is.na(mm);
  
  me[me.na] = 0;
  mm[mm.na] = 0;
  
  if(type==1){
    Z = .C("lmEQTL_complete", as.integer(dims), as.double(me), 
            as.double(mm), as.integer(!me.na), as.integer(!mm.na), 
            as.double(sex),as.character(output), as.double(p.cut), 
            as.integer(add.only), as.integer(detail), 
            as.double(tol), as.double(nna.percent), 
            as.integer(succeed), PACKAGE="eqtl.lm");
  }
  
  if(type==2){
    Z = .C("lmEQTL_backward", as.integer(dims), as.double(me), 
            as.double(mm), as.integer(!me.na), as.integer(!mm.na), 
            as.double(sex), as.character(output), as.double(p.cut), 
            as.double(lrt.p.cut), as.double(tol),
            as.double(nna.percent), as.integer(succeed),
            PACKAGE="eqtl.lm");
  }
  
  
  me[me.na] = NA;
  mm[mm.na] = NA;
  
  Z[[length(Z)]]
}
