"eQTL.reduce" <-
function(path, input, output, markerInfo){

    file.in = paste(path, input, sep="")

    A = read.table(file.in, sep="\t", header=TRUE)
    cat("input data dimension:", dim(A), "\n")
    
    cols = c("Gene_ID", "Marker_ID", "LR_Mk_M0_P")
    cols1 = paste(cols, collapse=", ")
    if(! all(cols %in% names(A))){
        stop("input eqtl result must have columns ", cols1, "\n")
    }

    cols = c("ID", "chrom", "start")
    if(! all(cols %in%  names(markerInfo))){
        stop("markerInfo must be a data.frame with ID, chrom and start\n")
    }

    # drop linkages to the markers without position information  
    to.drop  = which(is.na(markerInfo$chrom) | is.na(markerInfo$start))
    if(length(to.drop) > 0){
        mID2drop = markerInfo$ID[to.drop]
        link2drop = which(A$Marker_ID %in% mID2drop)
        if(length(link2drop) > 0){
            A = A[-link2drop,]
        }
    }
    
    gID = A$Gene_ID
    mID = A$Marker_ID
    mCHR = markerInfo$chrom[mID]

    # order the eQTL results by gene and marker chromosome combination
    fact = as.factor(paste(gID, mCHR, sep="_"))
    odr  = order(fact)
    A    = A[odr,]
    fact = fact[odr]
    BestP = A$LR_Mk_M0_P

    # for each gene and marker chromosome combination, take rank
    rnks = tapply(BestP, fact, rank, ties.method = "first")
    rnks = unlist(rnks)
    keep = which(rnks==1)
    A = A[keep,]
    
    gID = A$Gene_ID
    mID = A$Marker_ID
    
    A = A[order(gID, mID),]
    
    file.out = paste(path, output, sep="")

    write.table(A, file = file.out, append = FALSE, quote = FALSE, 
                sep = "\t", eol = "\n", na = "\\N", dec = ".", 
                row.names=FALSE, col.names = TRUE)
}
