"eQTL.FDR" <-
function(path, input.tag, n.permute, pcuts, 
  maf=NULL, maf.cut=NULL, nobs=NULL, nobs.cut=NULL){
    
    np = length(pcuts)
    D.link = D.gene = FD.link = FD.gene = FDR.link = FDR.gene = numeric(np)

    file.in = sprintf("%s%s_eqtl.txt", path, input.tag)
    A = read.table(file.in, sep="\t", header=TRUE)
    cat("input data dimension:", dim(A), "\n")

    todrop = maf.drop = nobs.drop = numeric(0)
    
    if(!is.null(maf) & !is.null(maf.cut)){
      cat("applying restriction of minor allele frequency\n")
      maf.drop = which(maf <= maf.cut) - 1
    }
    
    if(!is.null(nobs) & !is.null(nobs.cut)){
      cat("applying restriction of number of observations\n")
      nobs.drop = which(nobs <= nobs.cut) - 1
    }

    if(length(maf.drop) > 0 || length(nobs.drop) > 0){
      todrop = union(maf.drop, nobs.drop)
      A = A[-which(A$Marker_ID %in% todrop),]
      cat("input data dimension:", dim(A), "\n")      
    }
    
    pLabel = c("LR_Mk_M0_P", "b_p")
    pLab = pLabel[which(pLabel %in% names(A))]
    for(i in 1:np){
        pcut = pcuts[i]
        geneID = A$Gene_ID[A[[pLab]] <= pcut]
        D.link[i] = length(geneID)
        D.gene[i] = length(unique(geneID))
    }
    
    for(p in 1:n.permute){
        file.in = sprintf("%s%s_eqtl_per_%d.txt", path, input.tag, p)
        A = read.table(file.in, sep="\t", header=TRUE)
        if(length(todrop)>0){
          A = A[-which(A$Marker_ID %in% todrop),]
        }

        for(i in 1:np){
            pcut = pcuts[i]
            geneID = A$Gene_ID[A[[pLab]] <= pcut]
            FD.link[i] = FD.link[i] + length(geneID)
            FD.gene[i] = FD.gene[i] + length(unique(geneID))
        }
    }
    
    FD.link = FD.link/n.permute
    FD.gene = FD.gene/n.permute
    
    FDR.link = FD.link/D.link
    FDR.gene = FD.gene/D.gene
    
    df = data.frame(pcuts, D.link, FD.link, FDR.link, D.gene, FD.gene, FDR.gene)
    df
}
