"causal.lr" <-
function(y0, y1, y2){
    
    if(!is.numeric(y0)){
        stop("y0 must be numeric vector\n")
    }
    if(!is.numeric(y1)){
        stop("y1 must be numeric vector\n")
    }
    if(!is.numeric(y2)){
        stop("y2 must be numeric vector\n")
    }

    if(length(y1) != length(y0) || length(y2) != length(y0)){
        stop("length of y0, y1 and y2 must be the same\n")
    }
    
    result = numeric(7)
    labl = ""

    keep = which(!(is.na(y0) | is.na(y1) | is.na(y2)))
    nn   = length(keep)
    
    y0   = y0[keep]
    y1   = y1[keep]
    y2   = y2[keep]
    
    lm01 = lm(y1~y0)
    lm02 = lm(y2~y0)
    lm12 = lm(y2~y1)
    lm21 = lm(y1~y2)
    
    lm01.resid2 = lm01$resid^2
    lm02.resid2 = lm02$resid^2
    lm12.resid2 = lm12$resid^2
    lm21.resid2 = lm21$resid^2

    sigma01 = sqrt(sum(lm01.resid2)/nn)
    sigma02 = sqrt(sum(lm02.resid2)/nn)
    sigma12 = sqrt(sum(lm12.resid2)/nn)
    sigma21 = sqrt(sum(lm21.resid2)/nn)

    logL01 = -lm01.resid2/(2*sigma01^2) - log(sigma01)
    logL02 = -lm02.resid2/(2*sigma02^2) - log(sigma02)
    logL12 = -lm12.resid2/(2*sigma12^2) - log(sigma12)
    logL21 = -lm21.resid2/(2*sigma21^2) - log(sigma21)
    
    # ----------------------------------- #
    # causal model:     y0 -> y1 -> y2
    # reactive model:   y0 -> y2 -> y1
    # independent model:y1 <- y0 -> y2
    # ----------------------------------- #
    lLCau = logL01 + logL12
    lLRec = logL02 + logL21
    lLInd = logL01 + logL02
    
    logLCau = sum(lLCau)
    logLRec = sum(lLRec)
    logLInd = sum(lLInd)

    logL = c(logLCau, logLRec, logLInd)
    which.model = which.max(logL)
    
    # causal model is the most plausible one
    if(which.model == 1){
        labl = "causal"
        
        # causal model vs. reactive model
        lr1 = logLCau - logLRec
        ww1 = mean((lLCau - lLRec)^2) - (lr1/nn)^2
        
        # causal model vs. independent model
        lr2 = logLCau - logLInd
        ww2 = mean((lLCau - lLInd)^2) - (lr2/nn)^2
    }

    # reactive model is the most plausible one
    if(which.model == 2){
        labl = "reactive"
        
        # reactive model vs. causal model
        lr1 = logLRec - logLCau
        ww1 = mean((logLRec - lLCau)^2) - (lr1/nn)^2

        # reactive model vs. independent model
        lr2 = logLRec - logLInd
        ww2 = mean((logLRec - lLInd)^2) - (lr2/nn)^2
    }

    # independent model is the most plausible one
    if(which.model == 3){
        labl = "independent"

        # independent model vs. causal model
        lr1 = logLInd - logLCau
        ww1 = mean((lLInd - lLCau)^2) - (lr1/nn)^2
        
        # independent model vs. reactive model
        lr2 = logLInd - logLRec
        ww2 = mean((lLInd - lLRec)^2) - (lr2/nn)^2
    }
    
    if(max(lr1, lr2)<0.01){
        z   = NA
        pval = 1
    }else{
        z   = min(lr1/sqrt(ww1*nn), lr2/sqrt(ww2*nn))
        pval = 1-pnorm(z)
    }
    
    result = list(logL=logL, pval=pval, label=labl)
    result
}

