\name{lrt.diploid}
\alias{lrt.diploid}
\alias{lrt.haploid}
\title{ likelihood ratio test of association equivalence }
\description{
  This is an iternal function used by eqtl.module.
  Likelihood ratio test are used to evaluate wether the association
  betwen one gene expression trait and two markers are equivalent.
}
\usage{
lrt.haploid(gd, md0, md1)
lrt.diploid(gd, md0, md1, sex, interaction = FALSE)
}
\arguments{
  \item{gd}{ gene expression profile }
  \item{md0}{ genotype data of one marker to which gd is linked.
    The linkage gd~md0 is stronger than linkage gd~md1 }
  \item{md1}{ genotype data of one marker to which gd is linked.
    The linkage gd~md1 is weaker than linkage gd~md1 }
  \item{sex}{ a vector of sex indicator, the mean effect of sex is
    always in the linear model }
  \item{interaction}{ whether include the interaction between sex
    and the marker in the linear model }
}
\details{
  Linear model is used to quantify the significance of one linkage.
  For haploid organism, the model is just lm(gd~md), where gd is
  one gene expression profile and md is genotype data of one mareker.
  For diploid organism, the default model is
  lm(gd~sex + add + dom),
  where add/dom are the additive/dominant effects, respectively.
  If interaction is TRUE, then the linear model
  includes interaction between genetic effects and sex:
  lm(gd~sex + add + dom + add:sex + dom:sex).
  After fitting two linear models for the two markers md0 and md1,
  likelihood ratio test of non-nested models are applied to
  test whether these two models are equivalent or not.
}
\value{
    p-value of the likelihood ratio test
}
\examples{
md0 = runif(100)
md1 = md0
md0[md0 <= 0.5] = -1
md0[md0 >= 0.5] = 1
md1[md1 <= 0.6] = -1
md1[md1 >= 0.6] = 1
gd = md0 + rnorm(100,0,0.5)
lrt.haploid(gd, md0, md1)
}
\references{
Likelihood ratio test for model selection and non-nested hypotheses.
Quang H. Vuong. Econometrica, Vol.57, No.2., pp. 307-333 }
\author{ Wei Sun wsun@bios.unc.edu }
\seealso{\code{\link{eQTL.module}}}
\keyword{ methods }
