\name{lmEQTL.slr.permute}
\alias{lmEQTL.slr.permute}
\title{ simple linear regression for eQTL, with permutation }
\description{
  Identify significant eQTL by simple linear regression, i.e.,
  y = a + bx. The significance is quantified by permutations.
  Possible grouping effects can be hanled by permuting within
  groups.
}
\usage{
lmEQTL.slr.permute(me, mm, output.tag, type, n.permute=10,
  p.cut=1e-4, cis.only=FALSE, cis.distance=1e6, eChr=0, ePos=0,
  mChr=0, mPos=0, trace.it=TRUE, tol=1e-7, nna.percent=0.75,
  np.max=100000, np=c(100, 1000, 5000, 10000, 50000),
  aim.p=c(0.1, 0.05, 0.02, 0.01, 0.002), confidence.p=0.0001,
  permute.grp=NULL)
}
\arguments{
  \item{me}{ matrix of gene expression }
  \item{mm}{ matrix of marker genotype, could be any numerical matrix }
  \item{output.tag}{ output file name tag }
  \item{type}{ if type=1, results of different permutations are
     written out as separate files; if type=2, permutation p-value
     is calculated for the most significant linkage of each gene}
  \item{n.permute}{ used when type=1, the number of permutations }
  \item{p.cut}{ used when type=1, p-value cut-off for the simple linear
  regression. }
  \item{cis.only}{ whether examine cis-linkage only. }
  \item{cis.distance}{ if the distance between a gene and a marker
   is smaller than cis.distance, we call it as cis-linkage. }
  \item{eChr}{ chromosomes of gene expression traits, must be
   a vector of integers, which means sex chromosomes (X, Y)
   need to be coded as numbers }
  \item{ePos}{ positions of gene expression traits, must be
   a vector of integers}
  \item{mChr}{ chromosomes of markers, must be a vector of integers,
   which means sex chromosomes (X, Y) need to be coded as numbers }
  \item{mPos}{ positions of markers, must be a vector of integers}
  \item{trace.it}{ If trace.it is TRUE, show the message of each
   permutation. If trace.it is FALSE, do not show such messages.
   If trace.it is an integer, for example, 100, then show the message
   each 100 permutations.}
  \item{tol}{ components of model matrix are discarded if the ratio
   of singular values $s_i/s_0$ falls below tol. }
  \item{nna.percent}{ minimum percentage of non-missing values. }
  \item{np.max}{ np.max is used if type=2, the maximum number of
   permutations }
  \item{np}{ np is used if type=2, number of permutations, a vector
   in ascending order }
  \item{aim.p}{ aim.p is used if type=2, the upper bound of
   permutation p-values to estimate, corresponding to the number
   of permutations in \code{np} }
  \item{confidence.p}{ given np[i], aim.p[i], confidence p-value
   is a binomial p-value determining whether more permutations
   are needed for one gene expression trait }
  \item{permute.grp}{ possible grouping in permutations.
   If permute.grp is not NULL, permutations are carried out with groups.
   This is useful when the samples form a few groups, for example,
   Caucasian patients vs. African American, and we do not want the
   eQTL result to be confounded by the grouping effects
  }
}
\value{
If type=1, for each permutation, the results are written into
 two output files: one file for mapping result, including gene ID,
 marker ID, regression coefficient, and p-value;
 the other file is a frequency table of the p-values.

If type=2, output a data frame with columns gene ID, marker ID,
 nominal p-value, permutation p-value and number of permutations.
}
\examples{
  data(simuD)
  me  = simuD$expression
  mm  = simuD$genotype
  sex = simuD$sex
  
  lmEQTL.slr.permute(me, mm, output.tag="test_lmEQTL", type=2, 
    permute.grp=sex, trace.it=FALSE, np.max=1000, 
    np=c(100, 500), aim.p=c(0.1, 0.05))
}
\author{ Wei Sun wsun@bios.unc.edu }
\keyword{ methods }
