\name{lmEQTL.permute}
\alias{lmEQTL.permute}
\title{ linear model of eQTL, with permutation }
\description{
  use linear model including sex, additive effect, dominant effect
  and possible interactions to find eQTL
  using permuted gene expression data.
}

\usage{
lmEQTL.permute(me, mm, sex, output.tag, n.permute, p.cut, type,
   add.only=FALSE, detail=FALSE, lrt.p.cut=0.01, tol=1e-7,
   nna.percent=0.75)
}
\arguments{
  \item{me}{ matrix of gene expression }
  \item{mm}{ matrix of markers, use -1, 1 to indicate homozygous and
    use 0 to indicate heterozygous }
  \item{sex}{ vector of sex indicator, use 0 and 1 }
  \item{output.tag}{ output file name tag }
  \item{n.permute}{ the number of permutations }
  \item{p.cut}{ p-value cut-off of likelihood ratio test comparing
    one model with baseline model, i.e., a model with only sex effect}
  \item{type}{ two types of linear model are implemented.
    1: complete result of 6 models.
    2: backward stepwise model selection. }
  \item{add.only}{ this parameter is only used when type=1.
    If type=1, and add.only=TRUE, only consider additive effect,
    i.e., only the frist 3 models: model 0-2. }
  \item{detail}{ this parameter is only used when type=1.
    By default, only print out LRT result of each model.
    If type=1, and detail=TRUE, print out the detail result
    including coefficients, coefficient p-values of each model. }
  \item{lrt.p.cut}{ this parameter is only used when type=2.
    p-value cut-off of likelihood ratio test comparing two models
    in backward stepwise model selection. }
  \item{tol}{ components of model matrix are discarded if
    the ratio of singular values $s_i/s_0$ falls below tol. }
  \item{nna.percent}{ minimum percentage of non-missing values. }
}
\details{
  If type = 1, complete result of the following 6 models
     are calculated:
	\item{model 0:}{g ~ sex}
	\item{model 1:}{g ~ sex + add}
	\item{model 2:}{g ~ sex + add + sex:add}
	\item{model 3:}{g ~ sex + add + dom}
	\item{model 4:}{g ~ sex + add + dom + sex:add}
	\item{model 5:}{g ~ sex + add + dom + sex:add + sex:dom}
	only those associations that are significant at least one of
  the models 1-5 are kept. The significance of model i is measured
  by the LRT between model i and model 0.

  If type = 2, backward stepwise model selection is used,
  and one of models 1-5, are selected.
  
  Note that the gene expression data is permuted conditioning
  on sex variable. In addition, in each iteration, the same
  permutation is done for each gene so that the correlation
  between gene expression traits are kept.
}
\value{
    The function return 1 if no error occurs.
    The result are written into the output file.

    The gene expression data are permuted specified number of times,
    and the results are writen into separately files
    for each permutation.

    If type=1, the output include LRT statistic,
    LRT p-values of each model compared with model 0,
    and coefficients, coefficients p-value if detail=1.
    
    If type=2, the output include the LRT, LRT p-values of
    stepwise model selection.
}
\note{
  NOTICE, it is efficient to merge premutation results across
  genes so that only a small number of permutations are needed
  for each gene. However, it is more accurate to carry out a
  large number of permutations for each gene and estimate
  permutation p-value gene by gene. See lmEQTL.slr.permute.
}
\examples{
  data(simuD)
  me  = simuD$expression
  mm  = simuD$genotype
  sex = simuD$sex
  lmEQTL.permute(me, mm, sex, "test_lmEQTL", 2, p.cut=0.01, type=2)
}
\author{ Wei Sun wsun@bios.unc.edu }

\keyword{ methods }
