\name{eplot}
\alias{eplot}
\title{ eQTL result plot }
\description{
  plot genome-wide eQTL result as well as hotspots.
}
\usage{
eplot(geneID, markerID, pvals, pcuts, cols, eChr, ePos, mChr,
  mPos, chroms, xlab="QTL Location", ylab="Transcript Location",
  plot.hotspots=TRUE, hotspots.cut=10)
}
\arguments{
  \item{geneID}{ a vector of gene IDs. If geneID=k, its chromosome
  and position information will be extracted from eChr[k] and
  ePos[k], respectively  }
  \item{markerID}{ a vector of marker IDs. If makrerID=k, its chromosome
  and position information will be extracted from mChr[k] and
  mPos[k], respectively  }
  \item{pvals}{ eQTL p-values }
  \item{pcuts}{ a vector of p-value cutoffs, for example c(1e-4, 1e-5) }
  \item{cols}{ a vector of the same length as pcuts, which indicate
   the colors for different p-value cutoffs. For example,
   if pcuts = c(1e-4, 1e-5), cols = c("green", "blue"),
   then all the associations with p-values within (1e-5, 1e-4] are
   plotted as green points and all the associations with p-values
   smaller or equal to 1e-5 are plotted as blue points
  }
  \item{eChr}{ chromosome of each gene, ordered by gene ID  }
  \item{ePos}{ position (within chromosome) of each gene,
    ordered by gene ID}
  \item{mChr}{ chromosome of each marker, ordered by marker ID }
  \item{mPos}{ poistion (within chromosome) of each marker,
    ordered by marker ID}
  \item{chroms}{ all the distinct chromosomes used }
  \item{xlab}{ label of x-axis }
  \item{ylab}{ label of y-axis }
  \item{plot.hotspots}{ whether to plot hotspots }
  \item{hotspots.cut}{ cutoff for hotspots, which simply produce a
  horizontal line in the plot }
}
\author{ Wei Sun wsun@bios.unc.edu }
\note{
  geneID, markerID and pvals are three vector of same length.
  One triplet of geneID[i], markerID[i], and pvals[i] indicates
  an association between a gene (ID=geneID[i]) and
  a marker (ID=markerID[i]), with p-value equals to pvals[i].
}
\examples{
data(eqtl.y112)
data(eInfo.y112)
data(mInfo.y112)

eq = eqtl.y112
mI = mInfo.y112
eI = eInfo.y112

eq[1:2,]
eI[1:2,]
mI[1:2,]

eplot(eq$geneID, eq$markerID, eq$pValue,
  pcuts = c(1e-6, 1e-7, 1e-8, 1e-9),
  cols  = c("green", "blue", "red", "black"),
  eChr  = eI$chr, ePos=0.5*(eI$start+eI$end),
  mChr  = mI$chr, mPos=mI$start,
  chroms = 1:16, xlab="eQTL Location", ylab="Transcript Location",
  plot.hotspots=TRUE, hotspots.cut=10)

}

\keyword{ methods }
