\name{eQTL.local.FDR}
\alias{eQTL.local.FDR}
\title{ Calculate local FDR }
\description{
  Calculate local FDR by merging the permutations of diffrent genes.
}
\usage{
eQTL.local.FDR(path, input.tag, n.permute, pcuts, pi0=NULL, toPlot=FALSE)
}
\note{
  NOTICE, it is efficient to merge premutation results across
  genes so that only a small number of permutations are needed
  for each gene. However, it is more accurate to carry out a
  large number of permutations for each gene and estimate
  permutation p-value gene by gene. See lmEQTL.slr.permute
}
\arguments{
  \item{path}{ the file path }
  \item{input.tag}{ the input file name tag, for permutation result }
  \item{n.permute}{ number of permutations }
  \item{pcuts}{ p-value cutoffs where FDR are evaluated }
  \item{pi0}{ proportion of H0 }
  \item{toPlot}{ whether to generate some diagnostic plots }
}
\value{
  A list
  \item{pi0 }{ proportion of null distribution }
  \item{FDR.link }{False Discovery Rate of linkages at given p-value cutoff}
  \item{lfdr.link }{local false discovery rate for all the significant linkages}
}
\examples{
  data(simuD)
  me  = simuD$expression
  mm  = simuD$genotype
  sex = simuD$sex
  lmEQTL(me, mm, sex, "test_lmEQTL", p.cut=0.01, type=2)
  lmEQTL.permute(me, mm, sex, "test_lmEQTL", 5, p.cut=0.01, type=2)
  fdr = eQTL.local.FDR("./", "test_lmEQTL", 5, pcuts=c(0.01, 0.001, 0.0001))
}
\author{ Wei Sun wsun@bios.unc.edu }
\seealso{ \code{\link{lmEQTL}}, \code{\link{lmEQTL.slr}},
\code{\link{lmEQTL.slr.permute}} }
\keyword{ methods }
