"plotModule" <-
function(module, eqtls, mInfo, figure="eqtl_module.ps")
{
    if(class(module) != "module"){
        stop("the first parameter must belong to class 'module'\n")
    }

    ## mFreq is the frequency of markers with eqtl
    mFreq = table(eqtls$markerID)
    
    ## mID is the ID of markers with eqtl
    mIDs  = as.numeric(names(mFreq))
    
    ## change chromosome X & Y to numerical values
    mChr  = mInfo$chr[mIDs]
    chrLabel = unique(mChr)
    mChr[mChr=="x"|mChr=="X"] = length(chrLabel) - 1
    mChr[mChr=="y"|mChr=="Y"] = length(chrLabel)
    mChr  = as.numeric(mChr)
    uChr  = unique(mChr)

    ## mSta is the marker position within chromosome
    mSta  = mInfo$start[mIDs] 
    
    # --------------------------------------------------------#
    # plot the modules chromosome by chromosome
    # --------------------------------------------------------#
    xl = "Marker Location"
    yl = "Number of Linked Genes"
    neqtl.cut = module[["neqtlCut"]]
    
    postscript(file = figure, width=8, height=8)
    par(mfrow = c(2,1))
    for(j in 1:length(uChr)){
        chr = uChr[j]
        mFreq.c = mFreq[mChr==chr]
        mSta.c  = mSta[mChr==chr]
        mID.c   = mIDs[mChr==chr]
        main    = paste("chr",chrLabel[j])
        yr      = c(0, max(neqtl.cut, max(mFreq.c)) + 5)
        plot(mSta.c, mFreq.c, type="h", main=main, xlab=xl, ylab=yl, 
            ylim=yr, col="gray")
        abline(h=neqtl.cut, lty=2, col="blue")
        mtext(neqtl.cut, side=4, line=1, at=neqtl.cut)

        # --------------------------------------#
        # order all the modules in one chromosome
        # by position
        # --------------------------------------#
        chr.str = sprintf("chr%d", chrLabel[j])
        mods.chr = module[[chr.str]]
        if(length(mods.chr) == 0) {next}
        mods.ID  = names(mods.chr)
        mods.Pos = numeric(length(mods.ID))
        for(t in 1:length(mods.ID)){
            mod = mods.chr[[mods.ID[t]]]
            mod.mSta = mSta.c[match(mod, mID.c)]
            mods.Pos[t] = min(mod.mSta)
        }

        mods.ID = mods.ID[order(mods.Pos)]
        # --------------------------------------#
        # draw the box indicating moduel
        # --------------------------------------#
        col.bg = c("lightblue2", "lightsalmon2")

        mmi = 0
        for(m in mods.ID){
            mmi = mmi + 1
            mod = mods.chr[[m]]
            mod.mFre = mFreq.c[match(mod, mID.c)]
            mod.mSta = mSta.c[match(mod, mID.c)]
            rect(min(mod.mSta), 0, max(mod.mSta), yr, 
                col = col.bg[mmi%%2+1], border = NA)
        }
        
        # --------------------------------------#
        # draw the lines of marker and count
        # --------------------------------------#
        col.line = c("darkred", "darkblue")
        mmi = 0
        for(m in mods.ID){
            mmi = mmi + 1
            mod = mods.chr[[m]]
            mod.mFre = mFreq.c[match(mod, mID.c)]
            mod.mSta = mSta.c[match(mod, mID.c)]
            text(mod.mSta[1], mod.mFre[1]+2, mod[1])
            for(t in 1:length(mod.mSta)){
                xxm = rep(mod.mSta[t], 2)
                yym = c(0, mod.mFre[t])
                lines(xxm,yym,col=col.line[mmi%%2+1])
            }
        }
    }
    dev.off()
}

