"module.score" <-
function(eD, mc, q=0.01, sex=NULL, use.dom=FALSE){

  if(!is.numeric(mc)){
    stop("mc should be a numeric vector\n")
  }
  
  if(ncol(eD) != length(mc)){
    stop("dimension of eD and mc do not match\n")
  }

  if(any(! unique(mc) %in% c(-1, 0, 1, NA))){
    stop("mc can only take value of -1, 0, 1, or NA\n")
  }
  
  add = dom = mc
  dom[which(add==1 | add==-1)] = -1
  dom[which(add==0)] = 1

  pval = numeric(nrow(eD))
  for(i in 1:nrow(eD)){
    y = eD[i,]
    if(is.null(sex) & !use.dom){
      l0 = summary(lm(y ~ add))
      pval[i] = l0$coef[rownames(l0$coef)=="add",4]
    }else if(!is.null(sex) && !use.dom){
      l0 = lm(y ~ sex)
      l1 = lm(y ~ sex + add + sex:add)
      an = anova(l0, l1)
      pval[i] = an[2,6]
    }else if(is.null(sex) && use.dom){
      l0 = lm(y ~ sex)
      l1 = lm(y ~ sex + add + dom)
      an = anova(l0, l1)
      pval[i] = an[2,6]
    }else if(is.null(sex) && use.dom){
      l0 = lm(y ~ sex)
      l1 = lm(y ~ sex + add + dom + sex:add + sex:dom)
      an = anova(l0, l1)
      pval[i] = an[2,6]
    }
  }
  
  remains = 1:nrow(eD)
  wm      = which.min(pval)
  use     = wm
  remains = remains[-wm]
  puse = pval[wm]
  
  while(puse[length(puse)] < q && length(use) < ncol(eD) - 10){
    pval = numeric(length(remains))
    for(i in 1:length(remains)){
      id = remains[i]
      y  = eD[id,]
      if(length(use)==1){
        yc = eD[use,]
      }else{
        yc = t(eD[use,])
      }
      
      if(is.null(sex) & !use.dom){
        l0 = summary(lm(y ~ yc + add))
        pval[i] = l0$coef[rownames(l0$coef)=="add",4]
      }else if(is.null(sex) && use.dom){
        l0 = lm(y ~ yc)
        l1 = lm(y ~ yc + add + dom)
        an = anova(l0, l1)
        pval[i] = an[2,6]
      }else if(!is.null(sex) && !use.dom){
        l0 = lm(y ~ sex + yc)
        l1 = lm(y ~ sex + yc + add + sex:add)
        an = anova(l0, l1)
        pval[i] = an[2,6]
      }else if(!is.null(sex) && use.dom){
        l0 = lm(y ~ sex + yc)
        l1 = lm(y ~ sex + yc + add + dom + sex:add + sex:dom)
        an = anova(l0, l1)
        pval[i] = an[2,6]
      }
    }

    wm      = which.min(pval)
    use     = c(use, remains[wm])
    remains = remains[-wm]
    puse    = c(puse, pval[wm])
  }

  list(geneID=use, pval=puse, score=sum(log(puse)))
}
