"lmEQTL.slr.permute" <-
function(me, mm, output.tag, type, n.permute=10, p.cut=1e-4,
  cis.only=FALSE, cis.distance=1e6, eChr=0, ePos=0,
  mChr=0, mPos=0, trace.it=TRUE, tol=1e-7, nna.percent=0.75,
  np.max=100000, np=c(100, 1000, 5000, 10000, 50000),
  aim.p=c(0.1, 0.05, 0.02, 0.01, 0.002), confidence.p=0.0001,
  permute.grp=NULL)
{
  if(is.vector(me)){
      ncol.me = length(me)
      nrow.me = 1
  }else{
      ncol.me = ncol(me)
      nrow.me = nrow(me)
  }

  if(is.vector(mm)){
      ncol.mm = length(mm)
      nrow.mm = 1
  }else{
      ncol.mm = ncol(mm)
      nrow.mm = nrow(mm)
  }

  if(ncol.mm != ncol.me){
      stop("mm and me have different number of columns!\n")
  }

  if(!is.null(permute.grp)){
    if(length(permute.grp) != ncol.me){
      stop("length of permute.grp does not match me!\n")
    }
  }
  
  if(cis.only){
    if(!is.numeric(eChr) || length(eChr) != nrow.me){
      stop(sprintf("eChr must be a numeric vector of length %d\n", nrow.me))
    }
    if(!is.numeric(ePos) || length(ePos) != nrow.me){
      stop(sprintf("ePos must be a numeric vector of length %d\n", nrow.me))
    }
    if(!is.numeric(mChr) || length(mChr) != nrow.mm){
      stop(sprintf("mChr must be a numeric vector of length %d\n", nrow.mm))
    }
    if(!is.numeric(mPos) || length(mPos) != nrow.mm){
      stop(sprintf("mPos must be a numeric vector of length %d\n", nrow.mm))
    }
  }

  dims = numeric(4)
  dims[1] = nrow.me
  dims[2] = nrow.mm
  dims[3] = ncol.me
  dims[4] = n.permute

  succeed = 0
  
  mm.na = is.na(mm)
  mm[mm.na] = 0
  
  if(type==1){
    for(p in 1:n.permute){
      cat("permutation", p, date(), "\n")
      
      if(is.null(permute.grp)){
        topermute = sample(ncol.me)
      }else{
        topermute = numeric(ncol.me)
        for(grp in unique(permute.grp)){
          ww = which(permute.grp==grp)
          topermute[ww] = sample(ww)
        }
      }
      me.p = me[,topermute]
      me.na = is.na(me.p)
      me.p[me.na] = 0
      
      output = character(2)
      output[1] = sprintf("%s_eqtl_per_%d.txt", output.tag, p)
      output[2] = sprintf("%s_freq_per_%d.txt", output.tag, p)
      
      Z = .C("lmEQTL_slr", as.integer(dims), as.double(me.p), 
              as.double(mm), as.integer(!me.na), as.integer(!mm.na), 
              as.character(output), as.double(p.cut),
              as.integer(cis.only), as.integer(cis.distance),
              as.integer(eChr), as.integer(ePos),
              as.integer(mChr), as.integer(mPos), 
              as.double(tol), as.double(nna.percent), 
              as.integer(succeed), PACKAGE="eqtl.lm")
    }
    mm[mm.na] = NA
    return(Z[[length(Z)]])
  }else if(type==2){

    if(length(np) != length(aim.p)){
      stop("the length of np must equal to the length of aim.p\n")
    }

    if(any(diff(np)<=0)){ stop("np must be strictly ascending\n") }

    if(any(diff(aim.p)>=0)){ stop("aim.p must be strictly descending\n") }

    if(np.max <= max(np)){
      stop("np.max must be bigger than max(np)\n")
    }

    me.na = is.na(me)
    me[me.na] = 0
    best.m = pval = ppval = numeric(nrow.me)

    cuts  = qbinom(1-confidence.p, np, aim.p)
    pcuts = cuts/np
    np  = c(np, np.max)
    nnp = c(np[1], diff(np))

    idum = round(runif(1, -1000000, -1))
    dims[4] = nnp[1]

    if(is.null(permute.grp)){
      Rgrp = Rngrp = Rgrpn = Rgrps = 0
    }else{
      Rgrp = 1
      Rngrp = length(unique(permute.grp))
      Rgrpn = numeric(Rngrp)
      Rgrps = matrix(0, nrow=Rngrp, ncol=ncol.me)
      i=0
      for(grp in unique(permute.grp)){
        i = i + 1
        ww = which(permute.grp==grp)
        Rgrpn[i] = length(ww)
        Rgrps[i,1:Rgrpn[i]] = ww - 1
      }
    }

    Z = .C("lmEQTL_slr_permute", as.integer(dims), as.double(me), 
            as.double(mm), as.integer(!me.na), as.integer(!mm.na), 
            as.double(p.cut), bestM = as.integer(best.m), 
            pval=as.double(pval), perP=as.double(ppval), 
            as.integer(cis.only), as.integer(cis.distance), 
            as.integer(eChr), as.integer(ePos), 
            as.integer(mChr), as.integer(mPos), as.integer(trace.it),
            as.double(tol), as.double(nna.percent), as.integer(idum),
            as.integer(Rgrp), as.integer(Rngrp), as.integer(Rgrpn),
            as.integer(Rgrps), as.integer(succeed), PACKAGE="eqtl.lm")

    best.m = Z[["bestM"]]
    pval  = Z[["pval"]]
    ppval = Z[["perP"]]
    npall = rep(nnp[1], dims[1])
    
    for(i in 2:length(np)){
      which.kp = which(ppval < pcuts[i-1])
      if(length(which.kp)==0){break}

      if(is.vector(me)){
        me1 = me
        me1.na = me.na
      }else{
        me1 = me[which.kp,]
        me1.na = me.na[which.kp,]
      }
      
      if(is.vector(me1)){
        dims[1] = 1
      }else{
        dims[1] = nrow(me1)
      }

      if(cis.only){
        eChr1 = eChr[which.kp]
        ePos1 = ePos[which.kp]
      }else{
        eChr1 = 0
        ePos1 = 0
      }
      dims[4] = nnp[i] # number of permutations
      bbm = pvs = ppvs = numeric(dims[1])
      Z = .C("lmEQTL_slr_permute", as.integer(dims), as.double(me1),
              as.double(mm), as.integer(!me1.na), as.integer(!mm.na),
              as.double(p.cut), bestM = as.integer(bbm),
              pval=as.double(pvs), perP=as.double(ppvs),
              as.integer(cis.only), as.integer(cis.distance),
              as.integer(eChr1), as.integer(ePos1),
              as.integer(mChr), as.integer(mPos), as.integer(trace.it),
              as.double(tol), as.double(nna.percent), as.integer(idum),
            as.integer(Rgrp), as.integer(Rngrp), as.integer(Rgrpn),
            as.integer(Rgrps), as.integer(succeed), PACKAGE="eqtl.lm")

      w2 = nnp[i]/np[i]
      w1 = 1 - w2
      ppval[which.kp] = w1*ppval[which.kp] + w2*Z[["perP"]]
      npall[which.kp] = np[i]
    }

    me[me.na] = NA
    mm[mm.na] = NA
    gID = 1:nrow.me
    mID = best.m+1
    dataF = data.frame(geneID=gID, markerID=mID, pval=pval,
      permuteP=ppval, npermute=npall)
    return(dataF)
  }else{
    stop("type can only be 1 or 2\n")
  }
}
