"lmEQTL.slr" <-
function(me, mm, output.tag, p.cut, cis.only=FALSE, cis.distance=1e6, 
  eChr=NULL, ePos=NULL, mChr=NULL, mPos=NULL, tol=1e-7, nna.percent=0.75){

    if(is.vector(me)){
        ncol.me = length(me)
        nrow.me = 1
    }else{
        ncol.me = ncol(me)
        nrow.me = nrow(me)
    }

    if(is.vector(mm)){
        ncol.mm = length(mm)
        nrow.mm = 1
    }else{
        ncol.mm = ncol(mm)
        nrow.mm = nrow(mm)
    }

    if(ncol.mm != ncol.me){
        stop("mm and me have different number of columns!")
    }
    
    if(cis.only){
      if(!is.numeric(eChr) || length(eChr) != nrow.me){
        stop(sprintf("eChr must be a numeric vector of length %d\n", nrow.me))
      }
      if(!is.numeric(ePos) || length(ePos) != nrow.me){
        stop(sprintf("ePos must be a numeric vector of length %d\n", nrow.me))
      }
      if(!is.numeric(mChr) || length(mChr) != nrow.mm){
        stop(sprintf("mChr must be a numeric vector of length %d\n", nrow.mm))
      }
      if(!is.numeric(mPos) || length(mPos) != nrow.mm){
        stop(sprintf("mPos must be a numeric vector of length %d\n", nrow.mm))
      }
    }
    
    dims = numeric(3)
    dims[1] = nrow.me
    dims[2] = nrow.mm
    dims[3] = ncol.me
    succeed = 0
    
    output = character(2)
    output[1] = sprintf("%s_eqtl.txt", output.tag)
    output[2] = sprintf("%s_freq.txt", output.tag)
    
    me.na = is.na(me)
    mm.na = is.na(mm)
    
    me[me.na] = 0
    mm[mm.na] = 0
    
    Z = .C("lmEQTL_slr", as.integer(dims), as.double(me), 
            as.double(mm), as.integer(!me.na), as.integer(!mm.na), 
            as.character(output), as.double(p.cut), as.integer(cis.only),
            as.integer(cis.distance), as.integer(eChr), as.integer(ePos), 
            as.integer(mChr), as.integer(mPos), as.double(tol), 
            as.double(nna.percent), as.integer(succeed), PACKAGE="eqtl.lm")
    
    me[me.na] = NA
    mm[mm.na] = NA
    
    Z[[length(Z)]]
}
