"lmEQTL.byChr.permute" <-
function(me, mm, chrs, sex, output.tag, n.permute, p.cut, type, detail=0, 
    lrt.p.cut=0.01, tol=1e-7, nna.percent=0.75){

    if(type!=1 && type !=2){
        stop("type must be 1 or 2\n")
    }
    
    if(is.vector(me)){
        ncol.me = length(me)
        nrow.me = 1
    }else{
        ncol.me = ncol(me)
        nrow.me = nrow(me)
    }

    if(is.vector(mm)){
        ncol.mm = length(mm)
        nrow.mm = 1
    }else{
        ncol.mm = ncol(mm)
        nrow.mm = nrow(mm)
    }

    if(ncol.mm != ncol.me){
        stop("mm and me have different number of columns!");
    }

    if(any(is.na(sex))){
        stop("sex variable should not have missing values\n");
    }
    
    if(any(sex != 0 & sex != 1)){
        stop("sex variable should only have values 0 or 1\n");
    }
    
    if(ncol.mm != length(sex)){
        stop("number of columns of me(mm) is different from length of sex!");
    }

    if(any(is.na(chrs))){
        stop("No missing value is not allowed for parameter chrs\n");
    }

    if(nrow.mm != length(chrs)){
        stop("number of rows of mm is different from length of chrs\n");
    }

    if(any(chrs != as.integer(chrs))){
        warning("chrs must be a vector of integers\n")
    }
    chrs = as.integer(chrs)
    
    if(any(diff(chrs) < 0)){
        stop("chrs must be sorted in ascending order\n")
    }

    dims = numeric(3);
    dims[1] = nrow.me;
    dims[2] = nrow.mm;
    dims[3] = ncol.me;
    succeed = 0;

    # generate the permutation matrix    
    pp = matrix(0, nrow=n.permute, ncol=ncol.me)
    which0 = which(sex==0)
    which1 = which(sex==1)
    for(i in 1:n.permute){
        pp[i,which0] = sample(which0)
        pp[i,which1] = sample(which1)
    }
    
    # missing data matrix for genotype
    mm.na = is.na(mm);
    mm[mm.na] = 0;

    chrs.tbl = as.data.frame(table(chrs))
    chr.freq = chrs.tbl$Freq
    n.chr    = length(chr.freq)

    for(p in 1:n.permute){
        cat("permutation", p, "\n")
        
        me.p = me[,pp[p,]]
        me.na = is.na(me.p);
        me.p[me.na] = 0;
        
        output = character(2);
        output[1] = sprintf("%s_eqtl_per_%d.txt", output.tag, p)
        output[2] = sprintf("%s_freq_per_%d.txt", output.tag, p)
        
        
        if(type==1){
            Z = .C("lmEQTL_complete_byChr", as.integer(dims), as.double(me.p), 
                    as.double(mm), as.integer(!me.na), as.integer(!mm.na), 
                    as.integer(chr.freq), as.integer(n.chr), 
                    as.double(sex),as.character(output), as.double(p.cut), 
                    as.integer(detail), as.double(tol), as.double(nna.percent), 
                    as.integer(succeed), PACKAGE="eqtl.lm");
        }
        
        if(type==2){
            Z = .C("lmEQTL_backward_byChr", as.integer(dims), as.double(me.p), 
                    as.double(mm), as.integer(!me.na), as.integer(!mm.na), 
                    as.integer(chr.freq), as.integer(n.chr), 
                    as.double(sex), as.character(output), as.double(p.cut), 
                    as.double(lrt.p.cut), as.double(tol), 
                    as.double(nna.percent), as.integer(succeed), 
                    PACKAGE="eqtl.lm");
        }
    }
    mm[mm.na] = NA;
    
    Z[[length(Z)]]
}
