`eplot` <-
function(geneID, markerID, pvals, pcuts, cols, eChr, ePos, mChr,
  mPos, chroms, xlab="QTL Location", ylab="Transcript Location",
  plot.hotspots=TRUE, hotspots.cut=10){

  if(length(cols) != length(pcuts)){
    stop("length(cols) != length(pcuts)\n")
  }

  valid.chroms = c(1:90, "X", "Y")
  wrongChr = chroms[!(chroms %in% valid.chroms)]
  if(length(wrongChr)>0){
    stop(wrongChr, " are not valid chromosome labels\n")
  }

  todrop = which(!(eChr %in% chroms))
  eChr[todrop] = NA
  ePos[todrop] = NA
  eChr[eChr=="X"] = 99
  eChr[eChr=="Y"] = 100
  eChr = as.integer(eChr)
  ePos = as.numeric(ePos)

  todrop = which(!(mChr %in% chroms))
  mChr[todrop] = NA
  mPos[todrop] = NA
  mChr[mChr=="X"] = 99
  mChr[mChr=="Y"] = 100
  mChr = as.integer(mChr)
  mPos = as.numeric(mPos)

  chrs = union(unique(eChr), unique(mChr))
  chrs = sort(as.numeric(chrs))
  num.chrs = chrs[chrs <= 90]
  chr.chrs = c(num.chrs, "X", "Y")
  max.num = max(num.chrs)
  if(max.num > length(num.chrs)){
    str = "there is no marker/gene locaiton information for some chromosomes\n"
    stop(str)
  }
  eChr[eChr==99]  = max.num+1
  eChr[eChr==100] = max.num+2
  mChr[mChr==99]  = max.num+1
  mChr[mChr==100] = max.num+2

  chreMax = tapply(ePos, eChr, max, na.rm=TRUE, simplify = FALSE)
  chrmMax = tapply(mPos, mChr, max, na.rm=TRUE, simplify = FALSE)

  chrMax = numeric(length(chrs))
  for(i in 1:length(chrs)){
    ch = as.character(i)
    chrMax[i] = max(chreMax[[ch]], chrmMax[[ch]])
  }

  ## plot genome-wise linkge result
  ek1   = list()
  pcuts = sort(pcuts, decreasing=TRUE)
  for(i in 1:(length(pcuts)-1)){
    wkp = which(pvals <= pcuts[i] & pvals > pcuts[i+1])
    ek1[[i]] = data.frame(Gene_ID=geneID[wkp], Marker_ID=markerID[wkp])
  }
  i = length(pcuts)
  wkp = which(pvals <= pcuts[i])
  ek1[[i]] = data.frame(Gene_ID=geneID[wkp], Marker_ID=markerID[wkp])

  if(plot.hotspots){
    layout(matrix(1:2,ncol=1), heights = c(7,2))
  }
  
  nChr = length(chrMax)
  chrLen = c(0, cumsum(chrMax))
  ep = ePos + chrLen[eChr]
  mp = mPos + chrLen[mChr]

  ymax = chrLen[nChr+1]
  bdr1 = -0.016*ymax
  bdr2 = -0.006*ymax

  par(mar=c(3,4,0,0))
  plot(c(bdr1,ymax*1.05), c(bdr1,ymax*1.05), type="n", xlab="",
    ylab="", main="", xaxt="n", yaxt="n", bty="n")
  mtext(xlab, side=1, line=1)
  mtext(ylab, side=2, line=1)
  for(i in 1:length(pcuts)){
    gpos = ep[ek1[[i]]$Gene_ID]
    mpos = mp[ek1[[i]]$Marker_ID]
    points(mpos, gpos, col=cols[i], pch=20, cex=0.5)
  }

  nchr.plot = floor(nChr/2)
  rect(rep(bdr1,nchr.plot), chrLen[seq(1,nChr,by=2)],
       rep(bdr2,nchr.plot), chrLen[seq(2,nChr+1,by=2)],
       border=NA, col="orange")
  rect(chrLen[seq(1,nChr,by=2)], rep(bdr1,nchr.plot),
       chrLen[seq(2,nChr+1,by=2)], rep(bdr2,nchr.plot),
       border=NA, col="orange")

  kp = seq(1,nChr,by=2)
  ats = 0.5*(chrLen[-1] + chrLen[-length(chrLen)])
  mtext(chr.chrs[kp], at=ats[kp], side=1, line=-0.5, cex=0.8)
  mtext(chr.chrs[kp], at=ats[kp], side=2, line=-0.5, cex=0.8)

  lg = character(length(pcuts))
  for(i in 1:(length(pcuts)-1)){
    lg[i] = (paste("(",pcuts[i+1],", ",pcuts[i],"]",sep=""))
  }
  i = length(pcuts)
  lg[i] = (paste("(",0,", ",pcuts[i],"]",sep=""))
  
  legend(bdr1, ymax*1.1, lg, pch=20, col=cols,
   horiz = TRUE, bty="n", box.lty=2, cex=0.9)
  lines(c(0,ymax*1.01), rep(ymax*1.01,2), lty=2)
  lines(rep(ymax*1.01,2), c(0,ymax*1.01), lty=2)
  if(plot.hotspots){
    ## plot hotspots
    M.IDs = markerID[which(pvals <= max(pcuts))]
    et = table(M.IDs)
    mIDs = as.numeric(names(et))
  
    par(mar=c(2,4,0,0))
    plot(mp[mIDs], et, xlim=c(bdr1,ymax*1.05),
      type="h", xlab="", ylab="Frequency", xaxt="n", bty="n")
    abline(v=chrLen, lty=2, col="seagreen")
    mtext(chr.chrs[kp], at=ats[kp], side=1, line=0, cex=0.8)
    lines(c(0,ymax*1.01), rep(hotspots.cut,2), lty=2)
  }
}
