
"eQTL.local.FDR" <-
function(path, input.tag, n.permute, pcuts, pi0=NULL, toPlot=FALSE){

    "plot4.lFDR" <- 
    function(F0, F1, logP1, logP0, n.permute){
        par(mfrow=c(2,2), cex=1.0)
        
        # at least have least linkages in one bin
        least = max(sum(F0)/1000)
        
        # if one bin has less than least linkage, do not consider it
        to = max(which(F1>least & F0>least))
        
        # start from first bin
        from = 1
        
        # ----------------------------------------------
        # (1) plot the counts of linkages in each bin
        # ----------------------------------------------
        pp = 0.01*(from:to)
        xl = "p-value"
        yl = "count"
        F1p = F1[from:to]
        F0p = F0[from:to]
        mm = "counts of linkages p-values"
        
        plot(pp, F1p, type="p", pch=20, col="red", xlab=xl, ylab=yl, main=mm)
        su = "in 100 bins (0,0.01), (0.01,0.02), ..., (0.99,1)"
        mtext(su, side=3, line=0.25)
        points(pp, F0p, pch=21, col="seagreen", cex=0.8)
        segments(pp, F1[from:to], pp, F0[1:to], col="grey")
        lg = c("counts in real data", "counts in permuted data  ")
        co = c("red", "seagreen")
        pc = c(20, 21)
        xx = quantile(pp, 0.2)
        
        legend(x=xx, y=F1[from], legend=lg, col=co, pch=pc, pt.cex=c(1,0.8))
        
        # ----------------------------------------------
        # (2) plot the ratio of cumulative counts
        # ----------------------------------------------
        pp = 0.01*(from:to)
        
        #c0 = c1 = numeric(to - from + 1)
        #for(i in from:to){
        #    c0[i] = sum(F0[i:to])
        #    c1[i] = sum(F1[i:to])
        #}
        
        xl = "p-value"
        yl = "ratio"
        rr = F1[from:to]/F0[from:to]
        mm = "ratio of counts per bin"
        plot(pp, rr, type="b", pch=20, col="orange", xlab=xl, ylab=yl, main=mm)
        su = "counts in real data / counts in permuted data"
        mtext(su, side=3, line=0.25)
    
        # ------------------------------------------------------
        # (3) plot two density curves, f1 and f0, in region [a,b]
        #     the density curves are scaled according to the 
        #     proportion of data in region [a,b]
        # ------------------------------------------------------
    
        from = max(min(logP1), min(logP0)) + log10(2)
        to0 = quantile(logP0, min(0.99999, 1-10/length(logP1)))
        to1 = quantile(logP1, min(0.99999, 1-10/length(logP1)))
        to  = min(to0, to1)
        to  = min(to, 10)
        
        d1 = density(logP1,from=from,to=to,n=2048)
        d0 = density(logP0,from=from,to=to,n=2048)

        yu = max(max(log(d1$y)), max(log(d0$y)))
        yl = min(min(log(d1$y)), min(log(d0$y)))
        
        xr = c(from, to)
        yr = c(yl,yu)
        xl = "-log10(p-value)"
        yl = "log(density)"
        mm = "density curves"
        plot(d1$x, log(d1$y),xlim=xr, ylim=yr, col="red", type= "l", 
          main=mm,xlab=xl,ylab=yl)
        lines(d0$x, log(d0$y), lty=2, col="seagreen")
        lg = c("density in real data", "density in permuted data  ")
        co = c("red", "seagreen")
        legend(x=quantile(d1$x, 0.2), y=yu, legend=lg, col=co, lty=c(1,2))
        
        # ------------------------------------------------------
        # (4) plot the ratio of two density curves, f0/f1
        # ------------------------------------------------------
        
        mm = "density ratios"
        yl = "density ratio"
        plot(d0$x, d0$y/d1$y, type="l", xlab=xl, ylab=yl, main=mm)
        su = "density in real data / density in permuted data"
        mtext(su, side=3, line=0.25)
    }
    
    feqtl = sprintf("%s%s_eqtl.txt", path, input.tag)
    ffreq = sprintf("%s%s_freq.txt", path, input.tag)
    A  = read.table(feqtl, sep="\t", header=TRUE)
    cat("input data dimension:", dim(A), "\n")
    B  = read.table(ffreq, sep="\t", header=TRUE)
    F1 = as.numeric(B[,-1])
    F0 = numeric(length(F1))
    
    # estimate the density of linkage score in real data
    if("LR_Mk_M0_P" %in%  names(A)){
      logP1 = -log10(A$LR_Mk_M0_P)
    }else if("b_p" %in% names(A)){
      logP1 = -log10(A$b_p)
    }else{
      stop("ah.. I am lost, which variable is the p-value again?")
    }
    
    # estimate the density of linkage score in permuted data
    pall = numeric(0)
    for(p in 1:n.permute){
        feqtl = sprintf("%s%s_eqtl_per_%d.txt", path, input.tag, p)
        ffreq = sprintf("%s%s_freq_per_%d.txt", path, input.tag, p)
        A  = read.table(feqtl, sep="\t", header=TRUE)

        if("LR_Mk_M0_P" %in%  names(A)){
          pall = c(pall, A$LR_Mk_M0_P)
        }else if("b_p" %in% names(A)){
          pall = c(pall, A$b_p)
        }else{
          stop("ah.. I am lost, which variable is the p-value again?")
        }
    
        B  = read.table(ffreq, sep="\t", header=TRUE)
        F0 = F0 + as.numeric(B[,-1])
    }
    logP0 = -log10(pall)
    F0 = F0/n.permute
    
    if(toPlot){
        plot4.lFDR(F0, F1, logP1, logP0, n.permute)
    }
    
    # ------------------------------------------------------
    # estimate pi0, the proportion of H0
    # ------------------------------------------------------   
    if(is.null(pi0)){
        # at least have nn linkages in one bin
        nn = max(sum(F0)/1000)
        # if one bin has less than least linkage, do not consider it
        to = max(which(F1>nn & F0>nn))
        # start from first bin
        from = 1       
        pi0 = median(F1[from:to]/F0[from:to])
    }
    
    # ------------------------------------------------------
    # estimate local FDR
    # ------------------------------------------------------   
     
    # lfdr for linkages from real data
    lfdr = numeric(length(logP1))
    
    # if the observed linkage score is more extreme than the maximum 
    # one in permuted data, the posterior probability is 1.
    max.logP0 = max(logP0)
    which.big = which(logP1 > max.logP0)
    if(length(which.big)>0){
      lfdr[which.big] = 0
    }
    
    which.small = which(logP1 <= max.logP0)
    logP2 = logP1[which.small]

    # estimate the density function
    from = min(logP0)
    to = max.logP0
    # density is estimated at n equally spaced points
    n  = 1024*8 
    
    dens0 = density(logP0, from=from, to=to, n=n)
    dens2 = density(logP2, from=from, to=to, n=n)
    
    n1 = length(logP1)
    n2 = length(logP2)

    dens2$y = dens2$y*(n2/n1)
    
    lfdrDen = pi0*dens0$y/dens2$y
    lfdrDen[is.infinite(lfdrDen)] = 1
    lfdrDen[is.na(lfdrDen)] = 1
    lfdrDen[1] = 1
    for(j in 2:length(dens2$y)){
      if(is.na(lfdrDen[j]) | lfdrDen[j] > lfdrDen[j-1]){
        lfdrDen[j] = lfdrDen[j-1]
      }
    }
    
    # density index for all the linkage scores from real data
    DenI = round((n-1)*(logP2 - from)/(to - from)) + 1
    lfdr[which.small] = lfdrDen[DenI]
    
    np = length(pcuts)
    FDR = FD = Di = numeric(np)
    logPcuts = -log10(pcuts)
    for(i in 1:length(logPcuts)){
        logPcut = logPcuts[i]
        w = which(logP1 >= logPcut)
        Di[i] = length(w)
        FD[i] = sum(lfdr[w])
        FDR[i] = FD[i]/Di[i]
    }
    
    FDRDf  = data.frame(pcuts, D=Di, FD, FDR)
    # lfdrTb = data.frame(log10.p = dens0$x, lfdr = lfdrDen)
    lfdrDf = data.frame(log10P1=logP1, lfdr=lfdr)
    ll = list(pi0 = pi0, FDR.link=FDRDf, lfdr.link=lfdrDf)
}
