\name{plotEqtl.byChr}
\alias{plotEqtl.byChr}
\title{ plot frequency of eQTL chromosome by chromosome }
\description{
  given the pre-computed eQTL result, plot the frequency of genes linked to one marker. Draw the plot chromosome by chromosome in order to show the detail.
}
\usage{
plotEqtl.byChr(mInfo, eqtls, figure = "eqtl.ps", neqtl.cut = NULL, p.binom = 0.05)
}
\arguments{
  \item{mInfo}{ information data frame of all the markers. This data.frame should include at least three variables: ID, chr (chromosome) and  start}
  \item{eqtls}{ data frame of eqtl mapping result. This data.frame should include at least two variables: markerID and geneID }
  \item{figure}{ file name of the figure }
  \item{neqtl.cut}{ if more than neqtl.cut gene expression profiles linked to one marker, this marker is one module or part of one module }
  \item{p.binom}{ if neqtl.cut is not specified, use binomial distribution to calculate neqtl.cut, \code{p.binom} is the p-value cut-off of binomial distribution }
}
\details{
}
\value{
none
}
\references{ }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{ }

\seealso{ \code{\link{plotEqtl.genome}}}
\examples{
data(mInfo.y112)
data(eqtl.y112)
plotEqtl.byChr(mInfo.y112, eqtl.y112, figure = "eqtl.ps", p.binom = 0.05)
}
\keyword{ hplot }
