\name{marker2marker}
\alias{marker2marker}
\title{ For all the genes linked to one marker, test whether another marker is an acceptable eQTL }
\description{
  For all the genes linked to one marker, m0, and another marker m1, carry out LRT comparing the linkages to m0 and m1.
}
\usage{
marker2marker(eData, mData, mInfo, eqtls, m0ID, m1ID, neqtl.cut = NULL, p.binom = 0.05, plrt.cut = 0.05, prop.cut = 0.05, haploid = TRUE)
}
\arguments{
  \item{eData}{ data matrix of gene expression data, each row is one gene, each column is one individual }
  \item{mData}{ data matrix of marker genotype, each row is one marker, each column is one individual }
  \item{mInfo}{ information data frame of all the markers. This data.frame should include at least four variables: ID, markerSym, chr (chromosome) and  start}
  \item{eqtls}{ data frame of eqtl mapping result. This data.frame should include at least three variables: markerID, geneID and pValue}
  \item{m0ID}{ the ID of the marker all genes are linked }
  \item{m1ID}{ the ID of another marker we want to test its effectiveness of explaining linkages }
  \item{neqtl.cut}{ if more than neqtl.cut gene expression profiles linked to one marker, this marker is one module or part of one module }
  \item{p.binom}{ if neqtl.cut is not specified, use binomial distribution to calculate neqtl.cut, \code{p.binom} is the p-value cut-off of binomial distribution }
  \item{plrt.cut}{ p-value cut-off of likelihood ratio test deciding whether the linkage from one gene expression profile gp to one marker mp0  describe the gene expression data better than the linkage from gp to another marker mp1. If p-value < plrt.cut, we conclude that gd is linked mp0. Otherwise, we conclude that  gd is linked to the region from mp0 to mp1}
  \item{prop.cut}{ If there are multiple gene expression profiles linked to marker, it could happen by chance that one likelihood ratio test p-value is smaller than cut-off value. prop.cut provide the cut-off of proportion of such significant p-values }
  \item{haploid}{ whether the organism is haploid. This function only handle SNP markers. So if the organism is haploid, the marker data mData is a matrix with only two values. If the organism is diploid, the marker data mData is a matrix with three values }
}
\details{
}
\value{
  a data frame, including the ID of the genes linked to m0 and the corresponding  LRT p-values.
}
\references{  }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{ }

\seealso{ \code{\link{eqtl.module}} }
\examples{
data(eData.y112)
data(mData.y112)
data(mInfo.y112)
data(eqtl.y112)

eData = eData.y112
mData = mData.y112
mInfo = mInfo.y112
eqtl  = eqtl.y112

m0ID = 354
m1ID = 355

marker2marker(eData, mData, mInfo, eqtls, m0ID, m1ID)

}
\keyword{ methods }
