\name{lrt.power}
\alias{lrt.power}
\title{ test power of the likelihood ratio test }
\description{
  test power of the likelihood ratio test between non-nested models
}
\usage{
lrt.power(n.sample, n.simu, plrt.cut, prop.cut, pvals, ns, ds)
}
\arguments{
  \item{n.sample}{ number of samples/individuals }
  \item{n.simu}{ number of simulations for each combination of (n,d) }
  \item{plrt.cut}{ p-value cut-off of likelihood ratio test }
  \item{prop.cut}{ proportion cut-off }
  \item{pvals}{ a vector of p-values from real data }
  \item{ns}{ number of genes linked to the marker of interest }
  \item{ds}{ The number of individuals that are different between the simulated true QTL and the simulated pseudo-QTL }
}
\details{
We would like to simulate the expression traits so that their linkage strengths are compatible with what we had observed from the real data. To achieve this goal, we gather the p values of the real data together and randomly select a subset of them with replacement. And then simulate data based on the samples p-values.
}
\value{
  \item{fpr }{the false positive rate}
  \item{fnr }{the false negative rate}
}
\references{  }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{ }

\examples{

n.sample = 112
n.simu = 200 

data(eqtl.y112)
pvals = eqtl.y112$pValue
pvals[which(pvals<2e-16)] = 1e-16

ns = seq(2, 4, by=2)
ds = seq(8, 10, by=2)

prop.cut = 0.2
plrt.cut = 0.1

lrtP = lrt.power(n.sample, n.simu, plrt.cut, prop.cut, pvals, ns, ds)

lrtP

}

\keyword{ methods }
