\name{causal.parCor}
\alias{causal.parCor}
\title{ causal analysis using partial correlation}
\description{
  Identify possible causal relations among three variables by checking partial correlations.
}
\usage{
causal.parCor(y0, y1, y2, p.cut = 0.01)
}
\arguments{
  \item{y0}{ a numeric vector that can only be cause. For example,  \code{y0} is a genetic marker or one cis-linked gene's expression profile}
  \item{y1}{ a numeric vector that is one candidate of linker between y0 and y2 }
  \item{y2}{ a numeric vector   }
  \item{p.cut}{ p-value cut-off of significance of correlation }
}
\details{
The three models considered are: causal model (y0 -> y1 -> y2), reactive model (y0 -> y2 -> y1) and independent model (y1 <- y0 -> y2). The partial correlation of y and z given x parCor(y,z|x) is defined as cor(lm(y~x)$resid, lm(z~x)$resid). If the true model is causal model, then parCor(y0,y2|y1) = 0. If the true model is reactive model, then parCor(y0,y1|y2) = 0. If the true model is independent model, then parCor(y1,y2|y0) = 0. We conclude that the true model is causal model if p-value of parCor(y0,y2|y1) > p.cut and p-values of parCor(y0,y1|y2) and parCor(y1,y2|y0) < p.cut. Similarly we can conclude that the true model is reactive model or independent model. If we cannot conclude one of these three models, we say that the relation is "unknown".
}
\value{
  a list including two components:
  \item{parCor }{a vector including three partial correlations and  corresponding p-values: (parCor(y0,y2|y1), p-value, parCor(y0,y1|y2), p-value, parCor(y1,y2|y0), p-value) }
  \item{label }{one of "causal", "reactive", "independent" and "unknown"}
}
\references{ none }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{none}
\seealso{ \code{\link{causal.lr}} }
\examples{
    y0 = rnorm(100)
    y1 = y0 + rnorm(100,0,0.5)
    y2 = y1 + rnorm(100,0,0.5)
    causal.parCor(y0, y1, y2, p.cut = 0.01)
}
\keyword{ methods }
