"Rlrt.power" <-
function(n, N, plrt.cut, prop.cut, pvs, Ms, ds, useBinom=FALSE){

    if(n%%2!=0){
        stop("n must be an even numbers\n")
    }
    
    if(any(ds%%2!=0)){
        stop("all values of d must be even numbers\n")
    }
    
    x1 = rep(0:1, c(n/2, n/2))
    
    ## --- d.f. of t-test is approximated by n-2 --- ##
    ts  = abs(qt(pvs/2, n-2)) 
    sigmas = sqrt(n/2)/ts
    
    fpr = fnr = matrix(NA, nrow=length(Ms), ncol=length(ds))
    
    for(p in 1:length(Ms)){
        M = Ms[p]
        cat("M =", M, "\n")
        
        if(useBinom){
            Mcut = qbinom(0.9,M,prop.cut)
        }else{
            Mcut = M*prop.cut
        }
        
        for(q in 1:length(ds)){
            d = ds[q]
            cat("d =", d, "\n")
            
            x2 = rep(0:1, c(n/2-d/2,n/2+d/2))
            x3 = rep(0:1, c(n/2+d/2,n/2-d/2))
            
            pi = matrix(0, nrow=N, ncol=2)
            
            i = 1
            while(i <= N){
                
                cat("i =", i, "\n")
                
                pv = pvs[i]
                
                pj = matrix(0, nrow=M, ncol=2)
                j = 1
                while(j <= M){
                    y = x1 + rnorm(n, 0, sigmas[i]);
                
                    t1  = t.test(y~x1)
                    p1  = t1$p.value
                    if(p1 > 2*pv || p1 < 0.5*pv){ next }
                    
                    t2  = t.test(y~x2)
                    p2  = t2$p.value
                    if(p2 < p1){ next }
        
                    t3  = t.test(y~x3)
                    p3  = t3$p.value
                    if(p3 < p1){ next }
                    
                    pj[j,1] = lrt.haploid(y, x1, x2)
                    if(p2 < p3){
                        pj[j,2] = lrt.haploid(y, x2, x3)
                    }else{
                        pj[j,2] = lrt.haploid(y, x3, x2)
                    }
                    j = j + 1
                }
                
                for(k in 1:2){
                    which.kp = which(pj[,k]<plrt.cut)
                    if(length(which.kp) > Mcut){
                        pi[i,k] = 1
                    }
                }
                
                i = i + 1
            }
            fpr[p,q] = 1 - sum(pi[,1])/N
            fnr[p,q]  = sum(pi[,2])/N
        }
    }
    
    list(fpr=fpr, fnr=fnr)
}

