"plotEqtl.genome" <-
function(mInfo, eqtls, neqtl.cut=NULL, p.binom=0.05, 
chrSize=NULL, organism=NULL){

    if(is.null(chrSize) && is.null(organism)){
        err = "no chrom size information provided\n"
        err = sprintf("%s can not generate the whole genome plot\n", err)
        stop(err)
    }
    
    if(!is.null(chrSize)){
        if(!is.data.frame(chrSize)){
            stop("chrSize should be a data.frame\n")
        }
        if(!all(c("CHROMOSOME", "LENGTH") %in% names(chrSize))){
            stop("Two variables in chrSize missing: CHROMOSOME & LENGTH\n")
        }
    }else if(organism == "yeast"){
        data(yeastChrSize)
        chrSize = yeastChrSize
    }else if(organism == "mosue"){
        data(mouseChrSize)
        chrSize = mouseChrSize
    }else if(organism == "human"){
        data(humanChrSize)
        chrSize = humanChrSize
    }else{
        err = " no chrom size information provided\n"
        err = sprintf("%s no chrom size information for %s\n", err, organism)
        err = sprintf("%s can not generate the whole genome plot\n", err)
        stop(err)
    }
    
    chrLen = as.numeric(chrSize$LENGTH)
    chrCum = c(0, cumsum(chrLen))

    mFreq = table(eqtls$markerID)
    mIDs  = as.numeric(names(mFreq))
    mChr  = mInfo$chr[mIDs]
    chrLabel = unique(mChr)
    mChr[mChr=="x"|mChr=="X"] = length(chrLabel) - 1
    mChr[mChr=="y"|mChr=="Y"] = length(chrLabel)
    mChr  = as.numeric(mChr)
    uChr  = unique(mChr)
    mSta  = mInfo$start[mIDs] 
    mPos  = mSta + chrCum[mChr] 

    # ----------------------------------------------- # 
    # neqtl.cut: number of eqtls per marker so that 
    # bigger than this is counted as hot-spot
    # ----------------------------------------------- # 
    
    if(is.null(neqtl.cut)){
        binom.n = nrow(eqtls)
        binom.p = 1/length(mIDs)
        neqtl.cut = qbinom(1-p.binom, binom.n, binom.p)
    }

    # ----------------------------------------------- #
    # plot the count of linked genes
    # ----------------------------------------------- #
    xl = "Marker Location"
    yl = "Number of Linked Genes"
    yr = c(0, 10*(max(mFreq)%/%10+1))
    
    # quartz(width=12, height=4)
    plot(mPos,mFreq,type="h",xlab=xl,ylab=yl,xaxt="n",ylim=yr)
    for(j in 1:max(mChr)){
        abline(v=chrCum[j], lty=2, col="orange")
        mtext(j, side=1, at=0.5*(chrCum[j] + chrCum[j+1]))
    }
    abline(v=chrCum[20], lty=2, col="orange")
    abline(h=neqtl.cut, lty=2, col="blue")
    mtext(neqtl.cut, side=4, line=1, at=neqtl.cut)
}

