"module2TF" <-
function(moduleGenes, bindData, bindExp, eInfo, matchCol, 
bindData.colOff=0, p.cut=0.001, p.hyper=0.01){

    bCol = bindData[[matchCol]]
    eCol = eInfo[[matchCol]]
    bindData = bindData[bCol %in% eCol,]
    bCol = bindData[[matchCol]]
    
    bindData = data.matrix(bindData[,-(1:bindData.colOff)])
    
    cat("dimension of actually used binding data: ")
    cat(dim(bindData))
    cat("\n")
    
    if(nrow(bindData) == 0){
        stop("no genes have binding data\n")
    }
    
    # count function
    count <- function(v,p){length(which(v<p))}
    # --------------------------------------- #
    # m = number of genes one TF binds
    # --------------------------------------- #
    m = apply(bindData, 2, count, p=p.cut)
    n = nrow(bindData) - m
    
    # --------------------------------------- #
    # module by module, find the TF 
    # that binds genes in module 
    # --------------------------------------- #
    mod.syms = names(moduleGenes)
    
    for(i in 1:length(mod.syms)){
        modSym = mod.syms[i]
        mod    = moduleGenes[[modSym]]
        modCol = mod[[matchCol]]
        
        matches = match(modCol, bCol)
        mod     = mod[!is.na(matches),]
        modBind = bindData[na.omit(matches),]
        mod.l   = mod$pValue
        mod.l   = -log(mod.l)
        ## log(100) = 4.6, -log(p) + 5 <=> p/100
        mod.l[is.infinite(mod.l)] = max(mod.l[is.finite(mod.l)])+4.6
        
        # --------------------------------------- #
        # calculate the hyper-genometirc p-value
        # --------------------------------------- #
        q = apply(modBind, 2, count, p=p.cut)
        k = nrow(modBind)
        p = 1-phyper(q-1, m, n, k)
        p[which(q<=1)] = 1
        keep = as.numeric(which(p < p.hyper))

        # --------------------------------------- #
        # check the correlation between 
        # binding strength and linkage score
        # --------------------------------------- #
        if(length(keep) == 0) {
            mTF = data.frame(modSym, TF=NA, q=NA, m=NA, n=NA, k, p=NA, cor=NA,
             p.cor=NA, bind.gene=NA); 
        }else{
            mod.b = -log(modBind[,keep])
            ## log(100) = 4.6, -log(p) + 5 <=> p/100
            mod.b[is.infinite(mod.b)] = max(mod.b[is.finite(mod.b)])+4.6
            if(length(keep) == 1){
                mod.b = matrix(mod.b, ncol=1)
            }
            cors = cor(mod.b, mod.l, use="pair")
            cors = round(cors, 3)
            p.cor = numeric(length(cors))
            b.sym = character(length(cors))
            for(kk in 1:length(keep)){
                l  = lm(mod.l ~ mod.b[,kk])
                sl = summary(l)
                p.cor[kk] = sl$coef[2,4]
                tmp.sym   = mod$geneSym[which(modBind[,keep[kk]]<p.cut)]
                b.sym[kk] = paste(tmp.sym, collapse="|")
            }
            p.cor = signif(p.cor, 2)
            TF    = bindExp$expSym[keep]
            p.mod = signif(p[keep],2)
            q.mod = q[keep]
            m.mod = m[keep]
            n.mod = n[keep]
            mTF = data.frame(modSym, TF, q=q.mod, m=m.mod, n=n.mod, k, p=p.mod, 
                cor=cors, p.cor=p.cor, bind.gene=b.sym, row.names = NULL)
            o.mod  = order(p.mod)
            mTF = mTF[o.mod,]
        }
        if(i == 1){
            mTF.all = mTF
        }else{
            mTF.all = rbind(mTF.all, mTF)
        }
    }
    row.names(mTF.all) = 1:nrow(mTF.all)
    mTF.all
}

