"marker2marker" <-
function(eData, mData, mInfo, eqtls, m0ID, m1ID, 
neqtl.cut=NULL, p.binom=0.05, plrt.cut=0.05, prop.cut=0.05, haploid=TRUE)
{
    md0 = mData[m0ID,]
    md1 = mData[m1ID,]
    
    to.keep = which((!is.na(md0)) & (!is.na(md1)))
    md0 = md0[to.keep]
    md1 = md1[to.keep]
    
    gIDs = eqtl$geneID[eqtl$markerID==m0ID]
    pval = numeric(length(gIDs))
    
    for(k in 1:length(gIDs)){
        g   = gIDs[k]
        gd  = as.numeric(eData[g,])[to.keep]
        if(haploid){
            pval[k] = lrt.haploid(gd, md0, md1)
        }else{
            pval[k] = lrt.diploid(gd, md0, md1)
        }
    }
    
    data.frame(gIDs, pval)
}

