"lrt.haploid" <-
function(gd, md0, md1){
    
    if(!(is.vector(gd) && is.vector(md0) && is.vector(md1))){
        stop("vectors are expected in 'lrt'\n")
    }
    
    nn = length(gd)
    if((length(md0) != nn) || (length(md1) != nn)){
        stop("vector length mismatch in 'lrt' \n")
    }

    nna = !(is.na(gd) | is.na(md0) | is.na(md1))
    y  = gd[nna]
    x0 = md0[nna]
    x1 = md1[nna]
    
    if(all(x0==x1)){ return(1.0) }
    
    nn = length(y)

    pval = 1.0
    
    SW = .C("lrt_haploid", as.double(y), as.double(x0), as.double(x1), 
        as.integer(nn), pval=as.double(pval), PACKAGE="eqtl.TF")
    
    SW$pval
}
