"lrt.diploid" <-
function(gd, md0, md1, sex, interaction=FALSE){
    
    if(!(is.vector(gd) && is.vector(md0) && is.vector(md1) && is.vector(sex))){
        stop("vectors are expected in 'lrt'\n")
    }
    
    nn = length(gd)
    if((length(md0) != nn) || (length(md1) != nn)){
        stop("vector length mismatch in 'lrt' \n")
    }

    gd.nna = !is.na(gd)
    yd  = gd[gd.nna]
    xd0 = md0[gd.nna]
    xd1 = md1[gd.nna]
    sex = sex[gd.nna]
    
    if(all(xd0==xd1)){ return(1.0) }
    
    nn = length(yd)
    
    xd0.dom = xd0
    xd0.dom[which(xd0==1 | xd0==-1)] = -1
    xd0.dom[which(xd0==0)] = 1

    xd1.dom = xd1
    xd1.dom[which(xd1==1 | xd1==-1)] = -1
    xd1.dom[which(xd1==0)] = 1

    if(interaction){
        l0 = lm(yd ~ sex + xd0 + xd0.dom + sex:xd0 + sex:xd0.dom)
        l1 = lm(yd ~ sex + xd1 + xd1.dom + sex:xd1 + sex:xd1.dom)
    }else{
        l0 = lm(yd ~ sex + xd0 + xd0.dom)
        l1 = lm(yd ~ sex + xd1 + xd1.dom)
    }
    
    sigma0 = sqrt(sum(l0$resid^2)/nn)
    sigma1 = sqrt(sum(l1$resid^2)/nn)
    
    lL0 = -(l0$resid)^2/(2*sigma0^2) - log(sigma0)
    lL1 = -(l1$resid)^2/(2*sigma1^2) - log(sigma1)
    
    lr01 = -nn*log(sigma0/sigma1)
    w01  = mean((lL0 - lL1)^2) - (lr01/nn)^2

    z1 = lr01/sqrt(w01*nn)

    pval = 1-pnorm(z1)
    pval
}

