
"eqtl.module" <-
function(eData, mData, mInfo, eqtls, neqtl.cut=NULL, p.binom=0.05, plrt.cut=0.05, prop.cut=0.05, haploid=TRUE)
{
    module = list()

    ## mFreq is the frequency of markers with eqtl
    mFreq = table(eqtls$markerID)
    
    ## mID is the ID of markers with eqtl
    mIDs  = as.numeric(names(mFreq))
    
    ## change chromosome X & Y to numerical values
    mChr  = mInfo$chr[mIDs]
    chrLabel = unique(mChr)
    mChr[mChr=="x"|mChr=="X"] = length(chrLabel) - 1
    mChr[mChr=="y"|mChr=="Y"] = length(chrLabel)
    mChr  = as.numeric(mChr)
    uChr  = unique(mChr)

    ## mSta is the marker position within chromosome
    mSta  = mInfo$start[mIDs] 

    # -------------------------------------------- # 
    # neqtl.cut: number of eqtls per marker so that 
    # bigger than this is counted as hot-spot
    # -------------------------------------------- # 
    
    if(is.null(neqtl.cut)){
        binom.n = nrow(eqtls)
        binom.p = 1/length(mIDs)
        neqtl.cut = qbinom(1-p.binom, binom.n, binom.p)
    }
    # ------------------------------------------------------------ #
    # find the module, chromosome by chromosome, first find
    # the marker to which most genes are linked to, then extend
    #
    # here we do not require all the markers are ordered
    # ------------------------------------------------------------ #
    
    for(j in 1:length(uChr)){
        mod.n = 0
        mod.chr = list()
        chr     = uChr[j]
        cat(paste("chromosome", chrLabel[j], "\n"))
        mFreq.c = mFreq[mChr==chr]
        mSta.c  = mSta[mChr==chr]
        mID.c   = mIDs[mChr==chr]
        mID.rs  = rank(mSta.c)
        
        ## indicator of wether one marker is used or not
        m.Used  = numeric(length(mID.c))
        
        while(max(mFreq.c) > neqtl.cut){
            mID   = mID.c[which.max(mFreq.c)]
            mID.r = mID.rs[mID.c == mID]
    
            # extend the hotspot to the flanking markers        
            mod = mID
            
            seqsL = list()
            tcount = 0
            
            if(mID.r > 1){
                # search for the upstream marker
                tcount = tcount + 1
                seqsL[[tcount]] = seq(mID.r-1, 1, -1)
            }
            if(mID.r < length(mID.c)){
                # search for the downstream marker
                tcount = tcount + 1
                seqsL[[tcount]] = seq(mID.r+1, length(mID.c), 1)
            }

            if(tcount == 0){ stop("error, no markers in this chromsome\n") }
            
            for(s in 1:tcount){
                seqs = seqsL[[s]]
                
                for(l in seqs){
                    if(m.Used[mID.rs==l]==1){break}
                    
                    # -----------------------------------------------------#
                    # mF is the ID of the Flanking marker we are considering
                    # -----------------------------------------------------#
                    mF  = mID.c[mID.rs==l] 
                    ## md0 should be the one with stronger linkage
                    md0 = as.numeric(mData[mF,])
                    md1 = as.numeric(mData[mID,])
                    to.keep = which((!is.na(md0)) & (!is.na(md1)))
                    md0 = md0[to.keep]
                    md1 = md1[to.keep]
                    
                    # -----------------------------------------------------#
                    # g.mF are IDs of all the genes linked to the marker mF
                    # p.mF will store the corresponding p-values
                    # -----------------------------------------------------#
                    g.mF = eqtls$geneID[eqtls$markerID==mF]
                    p.mF = numeric(length(g.mF))
                    
                    for(k in 1:length(g.mF)){
                        g   = g.mF[k]
                        gd  = as.numeric(eData[g,])[to.keep]
                        if(haploid){
                            p.mF[k] = lrt.haploid(gd, md0, md1)
                        }else{
                            p.mF[k] = lrt.diploid(gd, md0, md1)
                        }
                    }
                    
                    # --------------------------------------------#
                    # stop rule, 
                    # stop if more than 20% p-value < 0.1
                    # --------------------------------------------#
                    prop = length(which(p.mF<plrt.cut))/length(p.mF)
                    if(prop > prop.cut){ break }
                    else{ mod = c(mod, mF) } 
                }
            }
            
            m.Used[(mID.c %in% mod)]  = 1
            mFreq.c[(mID.c %in% mod)] = 0
    
            mod.n = mod.n + 1
            mod.str = sprintf("mod%d", mod.n)
            mod.chr[[mod.str]] = mod
        }
        chr.str = sprintf("chr%d", chrLabel[j])
        if(length(mod.chr) > 0){
            module[[chr.str]] = mod.chr
        }
    }
    module[["neqtlCut"]] = neqtl.cut
    
    class(module) = "module"
    module
}

