\name{yeastBind.data}
\alias{yeastBind.data}
\alias{yeastBind.exp}
\docType{data}
\title{ Transcription factor binding data of yeast}
\description{
  Transcription factor binding data of yeast under YPD conditions, including 204 transcription factors altogether. 
}
\usage{
    data(yeastBind.data)
    data(yeastBind.exp)
}
\format{
  yeastBind.data: data frame of binding p-values with 204 transcription factors on 6229 ORFs.
  \describe{
    \item{\code{ID}}{a numeric vector, gene indentifier}
    \item{\code{ORF}}{a character vector, open reading frame}
    \item{\code{geneSym}}{a character vector, gene symbol}
    \item{\code{EXP1}}{a numeric vector, the binding p-value}
    .....
    \item{\code{EXP204}}{a numeric vector, the binding p-value}
  }
  yeastBind.exp: data frame of details of experiments in yeastBind.data. There are 204 observations on the following 19 variables, and each observation corresponds to one transcription factor.
  \describe{
    \item{\code{ID}}{a numeric vector, 1, 2, ..., 204}
    \item{\code{expID}}{a character vector, EXP1, EXP2, ..., EXP204}
    \item{\code{expConfidence}}{a numeric vector, the confidence of each experiment}
    \item{\code{expSym}}{the corresponding transcription factor}
    \item{\code{mean}}{a numeric vector, mean values of binding p-values in each experiment}
    \item{\code{median}}{a numeric vector, median values of binding p-values in each experiment}
    \item{\code{Qp}}{a numeric vector, p percentile of binding p-values in each experiment}
    \item{\code{sd}}{a numeric vector, standard deviation of binding p-values in each experiment}
    \item{\code{nNA}}{a numeric vector, number of missing values in each experiment}
    \item{\code{nZero}}{a numeric vector, number of zeros in each experiment}
  }
}

\details{
}

\note{
The authors thank Young RA for the permission to include the CHIP-chip data in our R package. However the data in the R package is just our version of data and Young RA is not responsible for any errors and are not updating it to reflect any changes/improvements in the data set. 
}

\source{
Harbison CT, Gordon DB, Lee TI, Rinaldi NJ, Macisaac KD, Danford TW, Hannett
NM, Tagne JB, Reynolds DB, Yoo J, Jennings EG, Zeitlinger J, Pokholok DK, Kellis
M, Rolfe PA, Takusagawa KT, Lander ES, Gifford DK, Fraenkel E, Young RA. 
 Transcriptional regulatory code of a eukaryotic genome.
Nature. 2004 Sep 2;431(7004):99-104.
}
\references{
}
\examples{
data(yeastBind.data)
data(yeastBind.exp)
}
\keyword{datasets}
