\name{tfAct}
\alias{tfAct}
\alias{tfInfo}

\docType{data}

\title{ Transcription factor (TF) activity data and information }
\description{
    Information of TFs (tfInfo) include id, symbol and description. 
    Activity profiles of Tfs (tfAct) include id and activity on 112 yeast segregants.
}

\usage{
    data(tfAct)
    data(tfInfo)
}

\details{
  tfInfo is a data frame with 97 observations on the following 3 variables.
  \describe{
    \item{\code{id}}{a numeric vector from 1 to 97}
    \item{\code{symbol}}{TF Symbol }
    \item{\code{name}}{Same as TF Symbol unless it is a TF complex, then lists all TF symbols }
    \item{\code{description}}{TF description, from SGD}
 }
  tfAct is a data frame with 97 observations on the following 113 variables.
  \describe{
    \item{\code{id}}{a numeric vector from 1 to 97}
    \item{\code{V1}}{a numeric vector, TF activities on yeast segregant 1}
    ...
    \item{\code{V112}}{a numeric vector, TF activities on yeast segregant 112}
  }
}
\source{
}
\references{
 Yu T. and Li K.C. (2005) Inference of transcriptional regulatory network by two-stage constrained space factor analysis. Bioinformatics, 21, 4033-8.

Hong E.L. et al. (2006) Saccharomyces Genome Database. http://db.yeastgenome.org/. 

}
\examples{
data(tfAct)
data(tfInfo)
}
\keyword{datasets}
