\name{summary.module}
\alias{summary.module}
\title{ summarize each module }
\description{
  list markers, start and end of each module
}
\usage{
summary.module(module, mInfo)
}
\arguments{
  \item{module}{ result of function eqtl.module }
  \item{mInfo}{ information data frame of all the markers. This data.frame should include at least three variables: ID, chr (chromosome) and  start}
}
\details{
}
\value{
  a data frame including two components: 
  \item{modSym }{symbol of the module}
  \item{marker }{ m1-m2-m3, m1 is start marker, m2 is the marker from which this module is constructed, and m3 is the end marker. }
  \item{start }{ start position of the module }
  \item{end }{ end position of the module }
}
\references{  }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{ }
\seealso{ \code{\link{eqtl.module}} }
\examples{
data(eData.y112)
data(mData.y112)
data(eInfo.y112)
data(mInfo.y112)
data(eqtl.y112)
module = eqtl.module(eData.y112, mData.y112, mInfo.y112, eqtl.y112, 
p.binom = 0.05, plrt.cut = 0.1, prop.cut = 0.2, haploid = TRUE)
sumMod = summary(module, mInfo.y112)
mod.len = sumMod$end - sumMod$start + 1
hist(mod.len, xlab="length of eQTL modules", main="")
}
\keyword{ utilities }
