\name{plotEqtl.genome}
\alias{plotEqtl.genome}
\title{ plot frequency of eQTL of the whole genome }
\description{
  given the pre-computed eQTL result, plot the frequency of genes linked to one marker. Draw the plot in the whole genome scale.
}
\usage{
plotEqtl.genome(mInfo, eqtls, neqtl.cut = NULL, p.binom = 0.05, chrSize = NULL, organism = NULL)
}
\arguments{
  \item{mInfo}{ information data frame of all the markers. This data.frame should include at least three variables: ID, chr (chromosome) and  start}
  \item{eqtls}{ data frame of eqtl mapping result. This data.frame should include at least two variables: markerID and geneID }
  \item{neqtl.cut}{ if more than neqtl.cut gene expression profiles linked to one marker, this marker is one module or part of one module }
  \item{p.binom}{ if neqtl.cut is not specified, use binomial distribution to calculate neqtl.cut, \code{p.binom} is the p-value cut-off of binomial distribution }
  \item{chrSize}{ data frame including at least two varialbes: CHROMOSOME and LENGTH. The rows of this data frame should ordered by chromosome. }
  \item{organism}{ several organisms' chromosome size information are stored within this library, including yeast, mouse and human. So if user is using data of one of these organisms, he/she can just specify the organism and does not need to specify the parameter chrSize  }
}
\details{
}
\value{
none
}
\references{ }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{ }
\seealso{ \code{\link{plotEqtl.genome}}}
\examples{
data(mInfo.y112)
data(eqtl.y112)
plotEqtl.genome(mInfo.y112, eqtl.y112, p.binom = 0.05, organism = "yeast")
}
\keyword{ hplot }
