\name{plot.module}
\alias{plot.module}
\title{ plot the eqtl modules }
\description{
  plot eqtl modules chromosome by chromosome. Modules are found by function eqtl.module. 
}
\usage{
plot.module(module, eqtls, mInfo, figure="eqtl_module.ps")
}
\arguments{
  \item{mInfo}{ information data.frame of all the markers. This data.frame should include at least three variables: ID, chr (chromosome) and  start}
  \item{eqtls}{ data.frame of eqtl mapping result. This data.frame should include at least two variables: markerID and geneID }
  \item{module}{ modules found by function eqtl.module }
  \item{figure}{ the output figure name }
}
\details{
}
\value{
none
}
\references{ }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{ }

\seealso{\code{\link{eqtl.module}}}
\examples{
data(eData.y112)
data(mData.y112)
data(mInfo.y112)
data(eqtl.y112)
module = eqtl.module(eData.y112, mData.y112, mInfo.y112, eqtl.y112)
plot(module, eqtl.y112, mInfo.y112, figure = "eqtl_module.ps")
}
\keyword{ hplot }
