\name{module.genes}
\alias{module.genes}
\title{ find genes within one module }
\description{
  given eqtl modules, find out genes belong to each module, and find cis-linked gene among them as well
}
\usage{
module.genes(module, eqtls, eInfo, mInfo, cis.dist)
}
\arguments{
  \item{module}{ a list of the eQTL modules, result of function eqtl.module }
  \item{eqtls}{ data frame of eqtl mapping result. This data.frame should include at least two variables: markerID and geneID }
  \item{eInfo}{ data frame of all the genes' information. This data.frame should include at least five variables: ID, geneSym, chr (chromosome), start and end}
  \item{mInfo}{ data frame of all the markers' information. This data.frame should include at least three variables: ID, chr (chromosome) and  start}
  \item{cis.dist}{ a linkage is cis-linkage if the distance between gene and marker is smaller than cis.dist (bases) }
}
\details{
}
\value{
    a list of all the modules, each element of the list is a data.frame giving genes belong to this module and linkage information.
}
\references{ None. }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{ }

\seealso{\code{\link{eqtl.module}} \code{\link{write.module.genes}} \code{\link{summary.module.genes}}}
\examples{
data(eData.y112)
data(mData.y112)
data(eInfo.y112)
data(mInfo.y112)
data(eqtl.y112)
module = eqtl.module(eData.y112, mData.y112, mInfo.y112, eqtl.y112)
moduleGenes = module.genes(module, eqtl.y112, eInfo.y112, mInfo.y112, 10000)
}
\keyword{ methods }
