\name{lrt.diploid}
\alias{lrt.diploid}
\alias{lrt.haploid}
\title{ likelihood ratio test of linkage equivalence }
\description{
  likelihood ratio test testing wether the linkage from one gene expression profile to two markers are equivalent. This test is used in function eqtl.module.
}
\usage{
lrt.haploid(gd, md0, md1)
lrt.diploid(gd, md0, md1, sex, interaction = FALSE)
}
\arguments{
  \item{gd}{ gene expression profile }
  \item{md0}{ genotype data of one marker to which gd is linked. The linkage gd~md0 is stronger than linkage gd~md1 }
  \item{md1}{ genotype data of one marker to which gd is linked. The linkage gd~md1 is weaker than linkage gd~md1 }
  \item{sex}{ a vector of sex indicator, the mean effect of sex is always in the linear model }
  \item{interaction}{ whether include the interaction between sex and the marker  in the linear model }
}
\details{
  Linear model is used to quantify the significance of one linkage. For haploid organism, the model is just lm(gd~md), where gd is one gene expression profile and md is genotype data of one mareker. For diploid organism, the default model is lm(gd~sex + md.add + md.dom), where md.add is the additive effect and md.dom is the dominant effect. If interaction is TRUE, then the linear model include interaction between marker and sex: lm(gd~sex + md.add + md.dom + md.add:sex + md.dom:sex). After fitting two linear models for the two markers md0 and md1, likelihood ratio test of non-nested models are applied to test whether these two models are equivalent or not.
}
\value{
    p-value of the likelihood ratio test
}
\references{ Likelihood ratio test for model selection and non-nested hypotheses. Quang H. Vuong. Econometrica, Vol.57, No.2., pp. 307-333 }

\author{ Wei Sun sunwei@stat.ucla.edu }
\note{ }

\seealso{\code{\link{eqtl.module}}}
\examples{
md0 = runif(100)
md1 = md0
md0[md0 <= 0.5] = -1
md0[md0 >= 0.5] = 1
md1[md1 <= 0.6] = -1
md1[md1 >= 0.6] = 1
gd = md0 + rnorm(100,0,0.5)
lrt.haploid(gd, md0, md1)
}
\keyword{ methods }
