\name{eqtl.module}
\alias{eqtl.module}
\title{ find module based on eqtl mapping result }
\description{
  Usually the distribution of eqtl across the genome is not uniform. There are some hotspots, i.e. many gene expression profiles linked to one locus or one small region. 
}
\usage{
eqtl.module(eData, mData, mInfo, eqtls, neqtl.cut = NULL, p.binom = 0.05, plrt.cut = 0.05, prop.cut = 0.05, haploid = TRUE)
}
\arguments{
  \item{eData}{ data matrix of gene expression data, each row is one gene, each column is one individual }
  \item{mData}{ data matrix of marker genotype, each row is one marker, each column is one individual }
  \item{mInfo}{ information data frame of all the markers. This data.frame should include at least four variables: ID, markerSym, chr (chromosome) and  start}
  \item{eqtls}{ data frame of eqtl mapping result. This data.frame should include at least three variables: markerID, geneID and pValue}
  \item{neqtl.cut}{ if more than neqtl.cut gene expression profiles linked to one marker, this marker is one module or part of one module }
  \item{p.binom}{ if neqtl.cut is not specified, use binomial distribution to calculate neqtl.cut, \code{p.binom} is the p-value cut-off of binomial distribution }
  \item{plrt.cut}{ p-value cut-off of likelihood ratio test deciding whether the linkage from one gene expression profile gp to one marker mp0  describe the gene expression data better than the linkage from gp to another marker mp1. If p-value < plrt.cut, we conclude that gd is linked mp0. Otherwise, we conclude that  gd is linked to the region from mp0 to mp1}
  \item{prop.cut}{ If there are multiple gene expression profiles linked to marker, it could happen by chance that one likelihood ratio test p-value is smaller than cut-off value. prop.cut provide the cut-off of proportion of such significant p-values }
  \item{haploid}{ whether the organism is haploid. This function only handle SNP markers. So if the organism is haploid, the marker data mData is a matrix with only two values. If the organism is diploid, the marker data mData is a matrix with three values }
}
\details{
 Usually the distribution of eqtl across the genome is not uniform. There are some hotspots, i.e. many gene expression profiles linked to one locus or one small region. This function find such hotspots, i.e. modules, using likelihood ratio test of non-nested models.
}
\value{
  This function return a list
  \item{neqtlCut }{ the cut-off value of number of genes linked to one marker, it equals to either the parameter neatlCut or it is calculated based p.binom}
  \item{chri }{a list including all the modules found in chromosome i}
  ...
}
\references{ None. }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{ }
\seealso{  \code{\link{write.module}} write the result into a text file, \code{\link{plot.module}} draw a figure showing those modules found}
\examples{
data(eData.y112)
data(mData.y112)
data(mInfo.y112)
data(eqtl.y112)
module = eqtl.module(eData.y112, mData.y112, mInfo.y112, eqtl.y112, 
p.binom = 0.05, plrt.cut = 0.1, prop.cut = 0.2, haploid = TRUE)
}
\keyword{ methods }
