\name{eData.y112}
\alias{eData.y112}
\alias{mData.y112}
\alias{eInfo.y112}
\alias{mInfo.y112}

\docType{data}
\title{ yeast gene expression, maker genotype data }
\description{
  gene expression data of 6229 probes (6216 ORFs) in 112 yeast segregants and marker genotype data of 2956 markers in the same 112 yeast segregatns, together with gene information data and marker information data
}
\usage{
data(eData.y112)
data(mData.y112)
data(eInfo.y112)
data(mInfo.y112)
}

\details{
    The gene expression data and maker genotype data are data matrices; they are matched by column, i.e., the same column of eData.y112 and mData.y112 corresponds to the same yeast segregant. 
    The marker information mInfo.y112 is a data frame with 2956 observations on the following 3 variables
    \item{\code{ID}}{unique numeric identifier of one marker}
    \item{\code{chr}}{chromosome of the marker}
    \item{\code{start}}{the start point of the marker within the chromosome}
    The gene information eInfo.y112 is a data frame with 6229 observations on the following 6 variables
    \item{\code{ID}}{unique numeric identifier of one marker}
    \item{\code{ORF}}{open read frame identifier }
    \item{\code{geneSym}}{gene symbol }
    \item{\code{chr}}{chromosome of the gene}
    \item{\code{start}}{the start point of the gene within the chromosome}
    \item{\code{end}}{the end point of the gene within the chromosome}
}

\note{
The authors thank Rachel B. Brem and Leonid Kruglyak for the permission to include the eQTL data in our R package. However the data in the R package is just our version of data and Brem & Kruglyak aren't responsible for any errors and are not updating it to reflect any changes/improvements in the data set. 
}

\source{
  Brem RB, Kruglyak L. The landscape of genetic complexity across 5,700 gene expression traits in yeast. Proc Natl Acad Sci U S A. 2005 Feb 1;102(5):1572-7. 
  
  Brem RB, Storey JD, Whittle J, Kruglyak L. Genetic interactions between polymorphisms that affect gene expression in yeast. Nature. 2005 Aug 4;436(7051):701-3. 
}
\references{
}
\examples{
}
\keyword{datasets}
