\name{causal.lr}
\alias{causal.lr}
\title{ causal analysis using likelihood ratio test }
\description{
  Identify possible causal relations among three variables by comparing likelihood of three different models: causal model, reactive model and independent model.
}
\usage{
causal.lr(y0, y1, y2)
}
\arguments{
  \item{y0}{ a numeric vector that can only be cause. For example, \code{y0} is a genetic marker or one cis-linked gene's expression profile}
  \item{y1}{ a numeric vector that is one candidate of linker between y0 and y2}
  \item{y2}{ a numeric vector }
}
\details{
The three models considered are: causal model (y0 -> y1 -> y2), reactive model (y0 -> y2 -> y1) and (y1 <- y0 -> y2). The likelihoods of these three models are calculated and ordered. Likelihood ratio test between the most likely model and the second likely model are done and the p-value are returned
}
\value{
  a list including two components:
  \item{lr}{a vector including log likelihood of three models, log likelihood ratio of the most likely model and the second likely model, z-statistic and corresponding p-value }
  \item{label}{label of the most likely model: one of "causal", "reactive", "independent"}
}
\references{ 
Schadt EE, Lamb J, Yang X, Zhu J, Edwards S, Guhathakurta D, Sieberts SK,
Monks S, Reitman M, Zhang C, Lum PY, Leonardson A, Thieringer R, Metzger JM,
Yang L, Castle J, Zhu H, Kash SF, Drake TA, Sachs A, Lusis AJ. 
 An integrative genomics approach to infer causal associations between gene
expression and disease.
Nat Genet. 2005 Jul;37(7):710-7.

Likelihood ratio test for model selection and non-nested hypotheses. Quang H. Vuong. Econometrica, 1989, Vol.57, No.2., pp. 307-333.
}
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{none}
\seealso{ \code{\link{causal.parCor}} }
\examples{
    y0 = rnorm(100)
    y1 = y0 + rnorm(100,0,1)
    y2 = y1 + rnorm(100,0,1)
    causal.lr(y0, y1, y2)
}
\keyword{ methods }
