"Rlrt.haploid" <-
function(gd, md0, md1){
    
    if(!(is.vector(gd) && is.vector(md0) && is.vector(md1))){
        stop("vectors are expected in 'lrt'\n")
    }
    
    nn = length(gd)
    if((length(md0) != nn) || (length(md1) != nn)){
        stop("vector length mismatch in 'lrt' \n")
    }

    nna = !(is.na(gd) | is.na(md0) | is.na(md1))
    yd  = gd[nna]
    xd0 = md0[nna]
    xd1 = md1[nna]
    
    if(all(xd0==xd1)){ return(1.0) }
    
    nn = length(yd)

    l0 = lm(yd ~ xd0)
    l1 = lm(yd ~ xd1)
    
    l0.resid2 = l0$resid^2
    l1.resid2 = l1$resid^2
    
    sigma0 = sqrt(sum(l0.resid2)/nn)
    sigma1 = sqrt(sum(l1.resid2)/nn)
    
    lL0 = -l0.resid2/(2*sigma0^2) - log(sigma0)
    lL1 = -l1.resid2/(2*sigma1^2) - log(sigma1)
    
    lr01 = -nn*log(sigma0/sigma1)
    w01  = mean((lL0 - lL1)^2) - (lr01/nn)^2

    z1 = lr01/sqrt(w01*nn)

    pval = 1 - pnorm(z1)
    pval
}
