"write.module.genes" <-
function(moduleGenes, file){
    if(class(moduleGenes) != "module.genes"){
        stop("the first parameter must belong to class 'module.genes'\n")
    }
    
    cat("", file=file)
    for(m in names(moduleGenes)){
        df = moduleGenes[[m]]
        df = data.frame(moduleSym=m, df)
        write.table(df, file = file, append = TRUE, quote = FALSE, sep = "\t",
                    eol = "\n", na = "NA", dec = ".", row.names = FALSE,
                    col.names = FALSE, qmethod = c("escape", "double"))
    }        
}

