"summary.module.genes" <-
function(moduleGenes, cis.pvalue=NULL){
    if(class(moduleGenes) != "module.genes"){
        stop("the first parameter must belong to class 'module.genes'\n")
    }
    
    modSyms = names(moduleGenes)
    for(i in 1:length(modSyms)){
        modSym = modSyms[i]
        mod = moduleGenes[[modSym]]
        n   = nrow(mod)
        if(is.null(cis.pvalue)){
            cisGenes = mod$geneSym[mod$cis==1]
        }else{
            cisGenes = mod$geneSym[mod$cis==1 & mod$pValue <= cis.pvalue]
        }
        
        if(length(cisGenes) == 0){
            cisGenes = NA
        }else{
            cisGenes = paste(cisGenes, collapse="|")
        }
        sumMod   = data.frame(modSym=modSym, n=n, cisGenes=cisGenes)
        
        if(i==1){
            sumMod.all = sumMod
        }else{
            sumMod.all = rbind(sumMod.all, sumMod)
        }
    }
    row.names(sumMod.all) = 1:nrow(sumMod.all)
    sumMod.all
}
