"plotEqtl.byChr" <-
function(mInfo, eqtls, figure="eqtl.ps", neqtl.cut=NULL, 
p.binom=0.05){

    mFreq = table(eqtls$markerID)
    mIDs  = as.numeric(names(mFreq))
    mChr  = mInfo$chr[mIDs]
    chrLabel = unique(mChr)
    mChr[mChr=="x"|mChr=="X"] = length(chrLabel) - 1
    mChr[mChr=="y"|mChr=="Y"] = length(chrLabel)
    mChr  = as.numeric(mChr)
    uChr  = unique(mChr)
    mSta  = mInfo$start[mIDs] 

    # ----------------------------------------------- # 
    # neqtl.cut: number of eqtls per marker so that 
    # bigger than this is counted as hot-spot
    # ----------------------------------------------- # 
    
    if(is.null(neqtl.cut)){
        binom.n = nrow(eqtls)
        binom.p = 1/length(mIDs)
        neqtl.cut = qbinom(1-p.binom, binom.n, binom.p)
    }
    
    # ----------------------------------------------- #
    # plot the count of linked genes
    # ----------------------------------------------- #
    xl = "Marker Location"
    yl = "Number of Linked Genes"

    postscript(file = figure, width=8, height=8)
    par(mfrow = c(2,1))
    for(j in 1:length(uChr)){
        chr = uChr[j]
        mFreq.c = mFreq[mChr==chr]
        mSta.c  = mSta[mChr==chr]
        main = paste("chr",chrLabel[j])
        yr = c(0, max(neqtl.cut, max(mFreq.c)) + 1)
        plot(mSta.c, mFreq.c, type="h", main=main, xlab=xl,ylab=yl,ylim=yr)
        abline(h=neqtl.cut, lty=2, col="blue")
        mtext(neqtl.cut, side=4, line=1, at=neqtl.cut)
    }
    dev.off()
}

